/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.output.v1.Parameters;
import com.appland.appmap.output.v1.Value;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.ArgumentArray;
import com.appland.appmap.transform.annotations.BaseSystem;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookBinding;
import com.appland.appmap.transform.annotations.ISystem;
import com.appland.shade.javassist.CtBehavior;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ArgumentArraySystem
extends BaseSystem {
    private static final Boolean DEFAULT_VALUE = false;
    private Boolean wantsArgumentArray;

    private ArgumentArraySystem(CtBehavior hookBehavior, Boolean wantsArgumentArray) {
        super(hookBehavior);
        this.wantsArgumentArray = wantsArgumentArray;
    }

    public static ISystem from(CtBehavior hookBehavior) {
        Boolean wantsArgumentArray = (Boolean)AnnotationUtil.getValue(hookBehavior, ArgumentArray.class, DEFAULT_VALUE);
        return new ArgumentArraySystem(hookBehavior, wantsArgumentArray);
    }

    @Override
    public void mutateRuntimeParameters(HookBinding binding, Parameters runtimeParameters) {
        if (!this.wantsArgumentArray.booleanValue()) {
            runtimeParameters.add(new Value().setName("$$"));
            return;
        }
        Parameters targetParameters = binding.getTargetParameters();
        Value argArray = new Value();
        if (targetParameters.size() == 0) {
            argArray.setName("new Object[0]");
        } else {
            String args = IntStream.range(1, targetParameters.size() + 1).mapToObj(i -> String.format("com.appland.appmap.process.RuntimeUtil.boxValue($%d)", i)).collect(Collectors.joining(", ", "new Object[]{ ", " }"));
            argArray.setName(args);
        }
        runtimeParameters.add(argArray);
    }

    @Override
    public Integer getParameterPriority() {
        return 300;
    }

    @Override
    public Boolean validate(Hook hook) {
        Parameters hookParameters = hook.getParameters();
        if (this.wantsArgumentArray.booleanValue()) {
            return hookParameters.validate(hookParameters.size() - 1, "java.lang.Object[]");
        }
        return true;
    }

    @Override
    public Boolean validate(HookBinding binding) {
        if (this.wantsArgumentArray.booleanValue()) {
            return true;
        }
        Parameters hookParameters = binding.getHook().getParameters();
        Parameters targetParameters = binding.getTargetParameters();
        Integer numParams = hookParameters.size();
        Integer startIndex = hookParameters.size() - targetParameters.size();
        if (numParams - startIndex != targetParameters.size()) {
            return false;
        }
        try {
            for (int i = startIndex.intValue(); i < numParams; ++i) {
                Value hookParam = hookParameters.get(i);
                if (targetParameters.validate(i - startIndex, hookParam.classType).booleanValue()) continue;
                return false;
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }
}

