/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.com.googlecode.javaewah;

import com.appland.shade.com.googlecode.javaewah.Buffer;
import com.appland.shade.com.googlecode.javaewah.EWAHCompressedBitmap;
import com.appland.shade.com.googlecode.javaewah.RunningLengthWord;

public final class EWAHIterator
implements Cloneable {
    private int pointer;
    final RunningLengthWord rlw;
    private final int size;

    public EWAHIterator(Buffer buffer) {
        this.rlw = new RunningLengthWord(buffer, 0);
        this.size = buffer.sizeInWords();
        this.pointer = 0;
    }

    private EWAHIterator(int pointer, RunningLengthWord rlw, int size) {
        this.pointer = pointer;
        this.rlw = rlw;
        this.size = size;
    }

    public static EWAHIterator getEWAHIterator(EWAHCompressedBitmap bitmap) {
        return bitmap.getEWAHIterator();
    }

    public Buffer buffer() {
        return this.rlw.buffer;
    }

    public int literalWords() {
        return this.pointer - this.rlw.getNumberOfLiteralWords();
    }

    public boolean hasNext() {
        return this.pointer < this.size;
    }

    public RunningLengthWord next() {
        this.rlw.position = this.pointer;
        this.pointer += this.rlw.getNumberOfLiteralWords() + 1;
        return this.rlw;
    }

    public EWAHIterator clone() throws CloneNotSupportedException {
        return new EWAHIterator(this.pointer, this.rlw.clone(), this.size);
    }
}

