/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.lib;

import com.appland.shade.org.eclipse.jgit.annotations.NonNull;
import com.appland.shade.org.eclipse.jgit.lib.FileMode;
import com.appland.shade.org.eclipse.jgit.lib.Repository;
import com.appland.shade.org.eclipse.jgit.util.FS;
import com.appland.shade.org.eclipse.jgit.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;

public class FileModeCache {
    @NonNull
    private final CacheItem root = new CacheItem(FileMode.TREE);
    @NonNull
    private final Repository repo;

    public FileModeCache(@NonNull Repository repo) {
        this.repo = repo;
    }

    @NonNull
    public Repository getRepository() {
        return this.repo;
    }

    @NonNull
    public CacheItem getRoot() {
        return this.root;
    }

    public void safeCreateParentDirectory(String gitPath, File parentDir, boolean makeSpace) throws IOException {
        CacheItem cachedParent = this.safeCreateDirectory(gitPath, parentDir, makeSpace);
        cachedParent.remove(gitPath.substring(gitPath.lastIndexOf(47) + 1));
    }

    public CacheItem safeCreateDirectory(String gitPath, File dir, boolean makeSpace) throws IOException {
        FS fs = this.repo.getFS();
        int i = gitPath.lastIndexOf(47);
        String parentPath = null;
        if (i >= 0) {
            if (makeSpace && dir.isFile() || fs.isSymLink(dir)) {
                FileUtils.delete(dir);
            }
            parentPath = gitPath.substring(0, i);
            this.deleteSymlinkParent(fs, parentPath, this.repo.getWorkTree());
        }
        FileUtils.mkdirs(dir, true);
        CacheItem cachedParent = this.getRoot();
        if (parentPath != null) {
            cachedParent = this.add(parentPath, FileMode.TREE);
        }
        return cachedParent;
    }

    private void deleteSymlinkParent(FS fs, String gitPath, File workingTree) throws IOException {
        if (!fs.supportsSymlinks()) {
            return;
        }
        String[] parts = gitPath.split("/");
        int n = parts.length;
        CacheItem cached = this.getRoot();
        File p = workingTree;
        int i = 0;
        while (i < n) {
            boolean delete;
            CacheItem cachedChild;
            block11: {
                p = new File(p, parts[i]);
                cachedChild = cached != null ? cached.child(parts[i]) : null;
                delete = false;
                if (cachedChild != null) {
                    if (FileMode.SYMLINK.equals(cachedChild.getMode())) {
                        delete = true;
                    }
                } else {
                    try {
                        Path nioPath = FileUtils.toPath(p);
                        BasicFileAttributes attributes = nioPath.getFileSystem().provider().getFileAttributeView(nioPath, BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
                        if (attributes.isSymbolicLink()) {
                            delete = p.isDirectory();
                        } else if (attributes.isRegularFile()) {
                        }
                        break block11;
                    }
                    catch (IOException | InvalidPathException e) {}
                    break;
                }
            }
            if (delete) {
                FileUtils.delete(p, 4);
                if (cached == null) break;
                cached.remove(parts[i]);
                break;
            }
            cached = cachedChild;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    @NonNull
    private CacheItem add(String gitPath, FileMode finalMode) {
        block3: {
            if (gitPath.isEmpty()) {
                throw new IllegalArgumentException();
            }
            parts = gitPath.split("/");
            n = parts.length;
            i = 0;
            curr = this.getRoot();
            while (i < n) {
                next = curr.child(parts[i]);
                if (next == null) break;
                curr = next;
                ++i;
            }
            if (i != n) ** GOTO lbl18
            curr.setMode(finalMode);
            break block3;
lbl-1000:
            // 1 sources

            {
                curr = curr.insert(parts[i], i + 1 == n ? finalMode : FileMode.TREE);
                ++i;
lbl18:
                // 2 sources

                ** while (i < n)
            }
        }
        return curr;
    }

    public static class CacheItem {
        @NonNull
        private FileMode mode;
        private Map<String, CacheItem> children;

        public CacheItem(@NonNull FileMode mode) {
            this.mode = mode;
        }

        @NonNull
        public FileMode getMode() {
            return this.mode;
        }

        public CacheItem child(String childName) {
            if (this.children == null) {
                return null;
            }
            return this.children.get(childName);
        }

        public CacheItem insert(String childName, @NonNull FileMode childMode) {
            if (!FileMode.TREE.equals(this.mode)) {
                throw new IllegalArgumentException();
            }
            if (this.children == null) {
                this.children = new HashMap<String, CacheItem>();
            }
            CacheItem newItem = new CacheItem(childMode);
            this.children.put(childName, newItem);
            return newItem;
        }

        public CacheItem remove(String childName) {
            if (this.children == null) {
                return null;
            }
            return this.children.remove(childName);
        }

        void setMode(@NonNull FileMode mode) {
            this.mode = mode;
            if (!FileMode.TREE.equals(mode)) {
                this.children = null;
            }
        }
    }
}

