/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.runtime;

import com.appland.shade.org.tinylog.runtime.Timestamp;
import java.time.Instant;
import java.util.Date;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

public final class LegacyTimestamp
implements Timestamp {
    private static final long MILLISECOND_IN_NANOS = 1000000L;
    private final Date date;

    public LegacyTimestamp() {
        this.date = new Date();
    }

    public LegacyTimestamp(long milliseconds) {
        this.date = new Date(milliseconds);
    }

    @Override
    public Date toDate() {
        return this.date;
    }

    @Override
    @IgnoreJRERequirement
    public Instant toInstant() {
        return this.date.toInstant();
    }

    @Override
    public java.sql.Timestamp toSqlTimestamp() {
        return new java.sql.Timestamp(this.date.getTime());
    }

    @Override
    public long calcDifferenceInNanoseconds(Timestamp other) {
        return (this.date.getTime() - other.toDate().getTime()) * 1000000L;
    }
}

