/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.record;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Event;
import com.appland.appmap.record.CodeObjectTree;
import com.appland.appmap.record.Recorder;
import com.appland.appmap.util.GitUtil;
import com.appland.shade.com.alibaba.fastjson.JSONWriter;
import com.appland.shade.com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class AppMapSerializer {
    private final JSONWriter json;
    private SectionInfo currentSection = null;
    private final HashSet<String> sectionsWritten = new HashSet();

    private AppMapSerializer(Writer writer) {
        this.json = new JSONWriter(writer);
        this.json.config(SerializerFeature.DisableCircularReferenceDetect, true);
        this.json.startObject();
    }

    public static AppMapSerializer open(Writer writer) {
        return new AppMapSerializer(writer);
    }

    public static AppMapSerializer reopen(Writer writer, RandomAccessFile raf) throws IOException {
        long position = raf.getFilePointer();
        AppMapSerializer serializer = new AppMapSerializer(writer);
        serializer.flush();
        raf.seek(position);
        return serializer;
    }

    public void write(CodeObjectTree classMap, Recorder.Metadata metadata, Map<Integer, Event> eventUpdates) throws IOException {
        this.writeClassMap(classMap);
        try (GitUtil git = GitUtil.open();){
            this.writeMetadata(git, metadata);
        }
        this.writeEventUpdates(eventUpdates);
        this.finish();
    }

    private void setCurrentSection(String section, String type) throws IOException {
        if (this.currentSection != null && this.currentSection.name == section) {
            return;
        }
        if (this.sectionsWritten.contains(section)) {
            throw new IOException(String.format("%s section already written", section));
        }
        if (this.currentSection != null && this.currentSection.name != section) {
            if (this.currentSection.type == "object") {
                this.json.endObject();
            } else if (this.currentSection.type == "array") {
                this.json.endArray();
            }
        }
        if (this.currentSection == null || this.currentSection.name != section) {
            this.sectionsWritten.add(section);
        }
        this.currentSection = new SectionInfo(section, type);
        if (this.currentSection.type.equals("object")) {
            this.json.writeKey(section);
            this.json.startObject();
        } else if (this.currentSection.type.equals("array")) {
            this.json.writeKey(section);
            this.json.startArray();
        }
    }

    private void writeMetadata(GitUtil git, Recorder.Metadata metadata) throws IOException {
        this.setCurrentSection("version", "");
        this.json.writeKey("version");
        this.json.writeValue("1.2");
        this.setCurrentSection("metadata", "");
        this.json.writeKey("metadata");
        this.json.startObject();
        if (metadata.scenarioName != null) {
            this.json.writeKey("name");
            this.json.writeValue(metadata.scenarioName);
        }
        this.json.writeKey("app");
        this.json.writeValue(AppMapConfig.get().name);
        this.json.writeKey("language");
        this.json.startObject();
        this.json.writeKey("name");
        this.json.writeValue("java");
        this.json.writeKey("version");
        this.json.writeValue(System.getProperty("java.vm.version"));
        this.json.writeKey("engine");
        this.json.writeValue(System.getProperty("java.vm.name"));
        this.json.endObject();
        this.json.writeKey("client");
        this.json.startObject();
        this.json.writeKey("name");
        this.json.writeValue("appmap-java");
        this.json.writeKey("url");
        this.json.writeValue("https://github.com/appland/appmap-java");
        this.json.endObject();
        this.json.writeKey("recorder");
        this.json.startObject();
        this.json.writeKey("name");
        this.json.writeValue(metadata.recorderName);
        this.json.writeKey("type");
        this.json.writeValue(metadata.recorderType);
        this.json.endObject();
        this.json.writeKey("recording");
        this.json.startObject();
        if (metadata.recordedClassName != null) {
            this.json.writeKey("defined_class");
            this.json.writeValue(metadata.recordedClassName);
        }
        if (metadata.recordedMethodName != null) {
            this.json.writeKey("method_id");
            this.json.writeValue(metadata.recordedMethodName);
        }
        this.json.endObject();
        if (git != null) {
            this.json.writeKey("git");
            this.json.startObject();
            this.json.writeKey("repository");
            this.json.writeValue(git.getRepositoryURL());
            this.json.writeKey("branch");
            this.json.writeValue(git.getBranch());
            this.json.writeKey("commit");
            this.json.writeValue(git.getCommit());
            this.json.endObject();
        }
        if (metadata.sourceLocation != null) {
            this.json.writeKey("source_location");
            this.json.writeValue(metadata.sourceLocation);
        }
        if (metadata.frameworks.size() > 0) {
            this.json.writeKey("frameworks");
            this.json.startArray();
            for (Recorder.Framework framework : metadata.frameworks) {
                this.json.startObject();
                if (framework.name != null) {
                    this.json.writeKey("name");
                    this.json.writeValue(framework.name);
                }
                if (framework.version != null) {
                    this.json.writeKey("version");
                    this.json.writeValue(framework.version);
                }
                this.json.endObject();
            }
            this.json.endArray();
        }
        if (metadata.testSucceeded != null) {
            this.json.writeKey("test_status");
            this.json.writeValue(metadata.testSucceeded != false ? "succeeded" : "failed");
        }
        if (metadata.failureMessage != null) {
            this.json.writeKey("test_failure");
            this.json.startObject();
            this.json.writeKey("message");
            this.json.writeValue(metadata.failureMessage);
            if (metadata.sourceLocation != null && metadata.failureLine != null) {
                this.json.writeKey("location");
                this.json.writeValue(String.format("%s:%d", metadata.sourceLocation.split(":")[0], metadata.failureLine));
            }
            this.json.endObject();
        }
        this.json.endObject();
    }

    private void writeClassMap(CodeObjectTree codeObjects) throws IOException {
        this.setCurrentSection("class_map", "");
        this.json.writeKey("classMap");
        this.json.writeValue(codeObjects.toArray());
        this.json.flush();
    }

    public void writeEvents(List<Event> events) throws IOException {
        this.setCurrentSection("events", "array");
        for (Event event : events) {
            this.json.writeObject(event);
        }
        this.json.flush();
    }

    public void flush() throws IOException {
        this.json.flush();
    }

    private void writeEventUpdates(Map<Integer, Event> updates) throws IOException {
        this.setCurrentSection("eventUpdates", "");
        this.json.writeKey("eventUpdates");
        this.json.startObject();
        updates.forEach((k, v) -> {
            this.json.writeKey(k.toString());
            this.json.writeValue(v);
        });
        this.json.endObject();
        this.json.flush();
    }

    private void finish() throws IOException {
        this.setCurrentSection("EOF", "");
        this.json.endObject();
        this.json.close();
    }

    private class SectionInfo {
        public String name;
        public String type;

        SectionInfo(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }

    public static class FileSections {
        public static final String Version = "version";
        public static final String Metadata = "metadata";
        public static final String Events = "events";
        public static final String EventUpdates = "eventUpdates";
        public static final String ClassMap = "class_map";
    }
}

