/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.reflect;

import com.appland.appmap.process.hooks.http.ServletContext;
import com.appland.appmap.reflect.HttpHeaderDelegate;
import com.appland.appmap.reflect.HttpHeaders;
import com.appland.appmap.reflect.ReflectiveType;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class HttpServletRequest
extends ReflectiveType
implements HttpHeaders {
    private static final String RESOURCE_URL_PROVIDER = "org.springframework.web.servlet.resource.ResourceUrlProvider";
    private final HttpHeaderDelegate headerDelegate;
    private final String GET_METHOD = "getMethod";
    private final String GET_REQUEST_URI = "getRequestURI";
    private final String GET_PROTOCOL = "getProtocol";
    private final String GET_PARAMETER_MAP = "getParameterMap";
    private final String GET_ATTRIBUTE = "getAttribute";
    private final String SET_ATTRIBUTE = "setAttribute";
    private final String GET_ATTRIBUTE_NAMES = "getAttributeNames";
    private final String GET_SERVLET_CONTEXT = "getServletContext";
    private final String GET_SERVLET_PATH = "getServletPath";

    public HttpServletRequest(Object self) {
        super(self);
        this.headerDelegate = new HttpHeaderDelegate(self);
        this.addMethods("getMethod", "getRequestURI", "getProtocol", "getParameterMap", "getAttributeNames", "getServletContext", "getServletPath");
        this.addMethod("getAttribute", String.class);
        this.addMethod("setAttribute", String.class, Object.class);
    }

    public String getMethod() {
        return this.invokeStringMethod("getMethod", new Object[0]);
    }

    public String getRequestURI() {
        return this.invokeStringMethod("getRequestURI", new Object[0]);
    }

    public String getProtocol() {
        return this.invokeStringMethod("getProtocol", new Object[0]);
    }

    public Map<String, String[]> getParameterMap() {
        return this.invokeMethod("getParameterMap", new HashMap(), new Object[0]);
    }

    public Object getAttribute(String name) {
        return this.invokeObjectMethod("getAttribute", name);
    }

    public void setAttribute(String key, Object value) {
        this.invokeObjectMethod("setAttribute", key, value);
    }

    public Enumeration<String> getAttributeNames() {
        return (Enumeration)this.invokeObjectMethod("getAttributeNames", new Object[0]);
    }

    public ServletContext getServletContext() {
        return new ServletContext(this.invokeObjectMethod("getServletContext", new Object[0]));
    }

    public String getServletPath() {
        return this.invokeStringMethod("getServletPath", new Object[0]);
    }

    @Override
    public HttpHeaderDelegate getHeaderDelegate() {
        return this.headerDelegate;
    }

    public boolean isForStaticResource() {
        Object obj = this.getAttribute(RESOURCE_URL_PROVIDER);
        if (obj == null) {
            return false;
        }
        ResourceUrlProvider provider = new ResourceUrlProvider(obj);
        return provider.getForLookupPath(this.getServletPath()) != null;
    }

    private static class ResourceUrlProvider
    extends ReflectiveType {
        private static String GET_FOR_LOOKUP_PATH = "getForLookupPath";

        public ResourceUrlProvider(Object self) {
            super(self);
            this.addMethod(GET_FOR_LOOKUP_PATH, String.class);
        }

        public String getForLookupPath(String path) {
            return this.invokeStringMethod(GET_FOR_LOOKUP_PATH, path);
        }
    }
}

