/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.config.Properties;
import com.appland.appmap.util.AppMapClassPool;
import com.appland.shade.javassist.ClassPool;
import com.appland.shade.javassist.CtClass;
import com.appland.shade.javassist.NotFoundException;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CtClassUtil {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private static String tracePrefix = Properties.DebugClassPrefix;

    public static Boolean isChildOf(CtClass candidateChildClass, CtClass parentClass) {
        String childClassName = candidateChildClass.getName();
        boolean traceClass = tracePrefix == null || childClassName.startsWith(tracePrefix);
        String parentClassName = parentClass.getName();
        if (childClassName.equals(parentClassName)) {
            return true;
        }
        CtClass[] interfaces = CtClassUtil.tryClass(candidateChildClass, "interfaces", candidateChildClass::getInterfaces);
        if (interfaces != null && interfaces.length > 0) {
            if (traceClass) {
                logger.trace("interfaces: {}", () -> Arrays.asList(interfaces).stream().map(c -> c.getName()).collect(Collectors.joining(",")));
            }
            for (CtClass superType : interfaces) {
                if (traceClass) {
                    logger.trace(() -> String.format("interface: %s", superType.getName()));
                }
                if (superType.getName().equals(parentClassName)) {
                    return true;
                }
                if (!CtClassUtil.isChildOf(superType, parentClass).booleanValue()) continue;
                return true;
            }
        } else if (traceClass) {
            logger.trace("no interfaces");
        }
        CtClass superClass = CtClassUtil.tryClass(candidateChildClass, "superclass", candidateChildClass::getSuperclass);
        if (traceClass) {
            logger.trace("superClass: {}", () -> superClass != null ? superClass.getName() : "null");
        }
        if (superClass == null) {
            return false;
        }
        if (superClass.getName().equals("java.lang.Object")) {
            return parentClassName.equals("java.lang.Object");
        }
        return CtClassUtil.isChildOf(superClass, parentClass);
    }

    private static <V> V tryClass(CtClass cls, String member, ClassAccessor<V> accessor) {
        try {
            return accessor.navigate();
        }
        catch (NotFoundException e) {
            logger.trace(() -> String.format("Resolving %s of class %s", member, cls.getName()));
            return null;
        }
    }

    public static Boolean isChildOf(String childClassName, CtClass parentClass) {
        String parentClassName = parentClass.getName();
        boolean namesEqual = childClassName.equals(parentClassName);
        if (namesEqual) {
            return true;
        }
        try {
            ClassPool cp = AppMapClassPool.get();
            CtClass childClass = cp.get(childClassName);
            Boolean ret = CtClassUtil.isChildOf(childClass, parentClass);
            logger.trace(() -> String.format("[0]childClassName: %s, parentClassName: %s ret: %s", childClassName, parentClass.getName(), ret));
            return ret;
        }
        catch (NotFoundException e) {
            logger.trace("[1]childClassName: {}, parentClassName: {} ret: false ({} not found)", childClassName, parentClassName, e.getMessage());
            return false;
        }
    }

    public static Boolean isChildOf(CtClass childClass, String parentClassName) {
        String childClassName = childClass.getName();
        boolean namesEqual = childClassName.equals(parentClassName);
        if (namesEqual) {
            return true;
        }
        try {
            ClassPool cp = AppMapClassPool.get();
            CtClass parentClass = cp.get(parentClassName);
            Boolean ret = CtClassUtil.isChildOf(childClass, parentClass);
            logger.trace(() -> String.format("[2]childClassName: %s, parentClassName: %s ret: %s", childClass.getName(), parentClassName, ret));
            return ret;
        }
        catch (NotFoundException e) {
            logger.trace("[3]childClassName: {}, parentClassName: {} ret: false ({} not found)", childClassName, parentClassName, e.getMessage());
            return false;
        }
    }

    public static Boolean isChildOf(String childClassName, String parentClassName) {
        boolean namesEqual = childClassName.equals(parentClassName);
        if (namesEqual) {
            return true;
        }
        try {
            ClassPool cp = AppMapClassPool.get();
            CtClass parentClass = cp.get(parentClassName);
            Boolean ret = CtClassUtil.isChildOf(childClassName, parentClass);
            logger.trace(() -> String.format("[4]childClassName: %s, parentClassName: %s ret: %s", childClassName, parentClassName, ret));
            return ret;
        }
        catch (NotFoundException e) {
            logger.trace("[5]childClassName: {}, parentClassName: {} ret: false ({} not found)", childClassName, parentClassName, e.getMessage());
            return false;
        }
    }

    public static Object isChildOf(Class<?> child, Class<?> parent) {
        if (child == null || parent == null) {
            return false;
        }
        return CtClassUtil.isChildOf(child.getName(), parent.getName());
    }

    public static void main(String[] argv) {
        String child = argv[0];
        String parent = argv[1];
        logger.info("{} {}", child, parent);
        System.out.println(String.format("isChildOf(%s, %s): %b", child, parent, CtClassUtil.isChildOf(child, parent)));
    }

    static interface ClassAccessor<V> {
        public V navigate() throws NotFoundException;
    }
}

