/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.AppMapAgentMethod;
import com.appland.appmap.transform.annotations.HookAnnotated;
import com.appland.appmap.transform.annotations.ISystem;
import com.appland.appmap.transform.annotations.SourceMethodSystem;
import com.appland.shade.javassist.CtBehavior;
import java.util.Map;
import java.util.Set;

public class HookAnnotatedSystem
extends SourceMethodSystem {
    private String annotationClass;

    private HookAnnotatedSystem(CtBehavior behavior, String annotationClass) {
        super(behavior, HookAnnotated.class);
        this.annotationClass = annotationClass;
    }

    public static ISystem from(CtBehavior behavior) {
        String annotatedClass = (String)AnnotationUtil.getValue(behavior, HookAnnotated.class, null);
        if (annotatedClass == null) {
            return null;
        }
        return new HookAnnotatedSystem(behavior, annotatedClass);
    }

    @Override
    public Boolean match(CtBehavior behavior, Map<String, Object> hookContext) {
        boolean ret = this.doMatch(behavior, hookContext);
        if (ret) {
            AnnotationUtil.setAnnotation(new AnnotationUtil.AnnotatedBehavior(behavior), AppMapAgentMethod.class);
        }
        return ret;
    }

    private Boolean doMatch(CtBehavior behavior, Map<String, Object> hookContext) {
        Boolean isExplicitlyExcluded = AppMapConfig.get().excludes(behavior);
        Set annotations = (Set)hookContext.get("annotations");
        return isExplicitlyExcluded == false && annotations != null && annotations.contains(this.annotationClass);
    }
}

