/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.transform.annotations;

import com.appland.appmap.config.AppMapConfig;
import com.appland.appmap.output.v1.Parameters;
import com.appland.appmap.transform.annotations.AnnotationUtil;
import com.appland.appmap.transform.annotations.ContinueHooking;
import com.appland.appmap.transform.annotations.Hook;
import com.appland.appmap.transform.annotations.HookBinding;
import com.appland.appmap.transform.annotations.MethodEvent;
import com.appland.shade.org.tinylog.TaggedLogger;
import java.util.stream.Collectors;

public class HookSite {
    private static final TaggedLogger logger = AppMapConfig.getLogger(null);
    private final Hook hook;
    private final Integer behaviorOrdinal;
    private String hookInvocation;
    private final MethodEvent methodEvent;
    private Boolean ignoresGlobalLock;
    private final HookBinding binding;

    HookSite(Hook hook, Integer behaviorOrdinal, HookBinding binding) {
        this.methodEvent = hook.getMethodEvent();
        this.hook = hook;
        this.behaviorOrdinal = behaviorOrdinal;
        this.binding = binding;
        this.ignoresGlobalLock = (Boolean)AnnotationUtil.getValue(hook.getBehavior(), ContinueHooking.class, false);
    }

    private void initHookInvocation() {
        logger.trace("hook: {}", () -> this.hook.getBehavior().getLongName());
        String event = this.methodEvent.getEventString().equals("call") ? String.format("%s.get().buildCallEvent(%d)", "com.appland.appmap.record.EventTemplateRegistry", this.behaviorOrdinal) : String.format("%s.get().buildReturnEvent(%d)", "com.appland.appmap.record.EventTemplateRegistry", this.behaviorOrdinal);
        Parameters parameters = this.hook.getRuntimeParameters(this.binding);
        String args = parameters.stream().map(param -> param.classType == null || param.classType.isEmpty() ? param.name : String.format("(%s) %s", param.classType, param.name)).collect(Collectors.joining(", ")).replace("$evt", event);
        String invocation = this.hook.getSourceSystem().toString() + "(" + args + ");";
        if (!this.getUniqueKey().isEmpty()) {
            invocation = "if (com.appland.appmap.process.ThreadLock.current().hasUniqueLock(\"" + this.getUniqueKey() + "\")) {" + invocation + "}";
        }
        this.hookInvocation = this.ignoresGlobalLock() != false ? invocation : "if (com.appland.appmap.process.ThreadLock.current().lock()) {" + invocation + "com.appland.appmap.process.ThreadLock.current().unlock();}";
    }

    public String getHookInvocation() {
        if (this.hookInvocation == null) {
            this.initHookInvocation();
        }
        return this.hookInvocation;
    }

    public MethodEvent getMethodEvent() {
        return this.methodEvent;
    }

    public String getUniqueKey() {
        return this.hook.getUniqueKey();
    }

    public Hook getHook() {
        return this.hook;
    }

    public Boolean ignoresGlobalLock() {
        return this.ignoresGlobalLock;
    }

    public Integer getBehaviorOrdinal() {
        return this.behaviorOrdinal;
    }
}

