/*
 * Decompiled with CFR 0.152.
 */
package com.appland.appmap.util;

import com.appland.appmap.output.v1.Event;
import com.appland.shade.javassist.CtBehavior;
import com.appland.shade.org.apache.commons.lang3.StringUtils;
import java.lang.reflect.Modifier;

public class StringUtil {
    public static String capitalize(String str) {
        return new String(str.substring(0, 1).toUpperCase() + str.substring(1));
    }

    public static String decapitalize(String str) {
        return new String(str.substring(0, 1).toLowerCase() + str.substring(1));
    }

    public static Boolean isAcronym(String str) {
        return !StringUtil.decapitalize(str).equals(str.toLowerCase());
    }

    public static String identifierToSentence(String identifier) {
        String[] packages = StringUtils.split(identifier, '.');
        String shortPackage = packages[packages.length - 1];
        shortPackage = StringUtils.replace(shortPackage, "Test", "");
        String[] words = StringUtils.splitByCharacterTypeCamelCase(shortPackage);
        Object[] formattedWords = new String[words.length];
        for (int i = 0; i < formattedWords.length; ++i) {
            String word = words[i];
            if (word.length() == 0) continue;
            formattedWords[i] = StringUtil.isAcronym(word) != false ? word : word.toLowerCase();
        }
        return StringUtil.capitalize(StringUtils.join(formattedWords, ' '));
    }

    public static String canonicalName(String className, boolean isStatic, String methodName) {
        return className + (isStatic ? "." : "#") + methodName;
    }

    public static String canonicalName(String packageName, String classSimpleName, boolean isStatic, String methodName) {
        return (packageName.length() > 0 ? packageName + "." + classSimpleName : classSimpleName) + (isStatic ? "." : Character.valueOf('#')) + methodName;
    }

    public static String canonicalName(Event event) {
        return StringUtil.canonicalName(event.definedClass, event.isStatic, event.methodId);
    }

    public static String canonicalName(CtBehavior behavior) {
        return StringUtil.canonicalName(behavior.getDeclaringClass().getName(), Modifier.isStatic(behavior.getModifiers()), behavior.getMethodInfo().getName());
    }
}

