/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.com.googlecode.javaewah;

import com.appland.shade.com.googlecode.javaewah.Buffer;
import java.util.Arrays;

final class LongArray
implements Buffer,
Cloneable {
    private int actualSizeInWords = 1;
    private long[] buffer = null;
    private static final int DEFAULT_BUFFER_SIZE = 4;

    public LongArray() {
        this(4);
    }

    public LongArray(int bufferSize) {
        if (bufferSize < 1) {
            bufferSize = 1;
        }
        this.buffer = new long[bufferSize];
    }

    @Override
    public int sizeInWords() {
        return this.actualSizeInWords;
    }

    @Override
    public void ensureCapacity(int capacity) {
        this.resizeBuffer(capacity - this.actualSizeInWords);
    }

    @Override
    public long getWord(int position) {
        return this.buffer[position];
    }

    @Override
    public long getLastWord() {
        return this.getWord(this.actualSizeInWords - 1);
    }

    @Override
    public void clear() {
        this.actualSizeInWords = 1;
        this.buffer[0] = 0L;
    }

    @Override
    public void trim() {
        this.buffer = Arrays.copyOf(this.buffer, this.actualSizeInWords);
    }

    @Override
    public void setWord(int position, long word) {
        this.buffer[position] = word;
    }

    @Override
    public void setLastWord(long word) {
        this.setWord(this.actualSizeInWords - 1, word);
    }

    @Override
    public void push_back(long word) {
        this.resizeBuffer(1);
        this.buffer[this.actualSizeInWords++] = word;
    }

    @Override
    public void push_back(Buffer buffer, int start, int number) {
        this.resizeBuffer(number);
        if (buffer instanceof LongArray) {
            long[] data = ((LongArray)buffer).buffer;
            System.arraycopy(data, start, this.buffer, this.actualSizeInWords, number);
        } else {
            for (int i = 0; i < number; ++i) {
                this.buffer[this.actualSizeInWords + i] = buffer.getWord(start + i);
            }
        }
        this.actualSizeInWords += number;
    }

    @Override
    public void negative_push_back(Buffer buffer, int start, int number) {
        this.resizeBuffer(number);
        for (int i = 0; i < number; ++i) {
            this.buffer[this.actualSizeInWords + i] = buffer.getWord(start + i) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.actualSizeInWords += number;
    }

    @Override
    public void removeLastWord() {
        this.setWord(--this.actualSizeInWords, 0L);
    }

    @Override
    public void negateWord(int position) {
        this.buffer[position] = this.buffer[position] ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void andWord(int position, long mask) {
        int n = position;
        this.buffer[n] = this.buffer[n] & mask;
    }

    @Override
    public void orWord(int position, long mask) {
        int n = position;
        this.buffer[n] = this.buffer[n] | mask;
    }

    @Override
    public void andLastWord(long mask) {
        this.andWord(this.actualSizeInWords - 1, mask);
    }

    @Override
    public void orLastWord(long mask) {
        this.orWord(this.actualSizeInWords - 1, mask);
    }

    @Override
    public void expand(int position, int length) {
        this.resizeBuffer(length);
        System.arraycopy(this.buffer, position, this.buffer, position + length, this.actualSizeInWords - position);
        this.actualSizeInWords += length;
    }

    @Override
    public void collapse(int position, int length) {
        System.arraycopy(this.buffer, position + length, this.buffer, position, this.actualSizeInWords - position - length);
        for (int i = 0; i < length; ++i) {
            this.removeLastWord();
        }
    }

    @Override
    public LongArray clone() {
        LongArray clone = null;
        try {
            clone = (LongArray)super.clone();
            clone.buffer = (long[])this.buffer.clone();
            clone.actualSizeInWords = this.actualSizeInWords;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    @Override
    public void swap(Buffer other) {
        if (other instanceof LongArray) {
            long[] tmp = this.buffer;
            this.buffer = ((LongArray)other).buffer;
            ((LongArray)other).buffer = tmp;
            int tmp2 = this.actualSizeInWords;
            this.actualSizeInWords = ((LongArray)other).actualSizeInWords;
            ((LongArray)other).actualSizeInWords = tmp2;
        } else {
            long[] tmp = new long[other.sizeInWords()];
            for (int i = 0; i < other.sizeInWords(); ++i) {
                tmp[i] = other.getWord(i);
            }
            int tmp2 = other.sizeInWords();
            other.clear();
            other.removeLastWord();
            other.push_back(this, 0, this.sizeInWords());
            this.buffer = tmp;
            this.actualSizeInWords = tmp2;
        }
    }

    private void resizeBuffer(int number) {
        int size = this.newSizeInWords(number);
        if (size >= this.buffer.length) {
            long[] oldBuffer = this.buffer;
            this.buffer = new long[size];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
        }
    }

    private int newSizeInWords(int number) {
        int size = this.actualSizeInWords + number;
        if (size >= this.buffer.length) {
            size = size < 32768 ? (size *= 2) : (size * 3 / 2 < size ? Integer.MAX_VALUE : size * 3 / 2);
        }
        return size;
    }
}

