/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.api;

import java.util.ArrayList;
import java.util.List;

public class CheckoutResult {
    public static final CheckoutResult ERROR_RESULT = new CheckoutResult(Status.ERROR, null);
    public static final CheckoutResult NOT_TRIED_RESULT = new CheckoutResult(Status.NOT_TRIED, null);
    private final Status myStatus;
    private final List<String> conflictList;
    private final List<String> undeletedList;
    private final List<String> modifiedList;
    private final List<String> removedList;

    CheckoutResult(Status status, List<String> fileList) {
        this(status, fileList, null, null);
    }

    CheckoutResult(Status status, List<String> fileList, List<String> modified, List<String> removed) {
        this.myStatus = status;
        this.conflictList = status == Status.CONFLICTS ? fileList : new ArrayList<String>(0);
        this.undeletedList = status == Status.NONDELETED ? fileList : new ArrayList<String>(0);
        this.modifiedList = modified;
        this.removedList = removed;
    }

    CheckoutResult(List<String> modified, List<String> removed) {
        this.myStatus = Status.OK;
        this.conflictList = new ArrayList<String>(0);
        this.undeletedList = new ArrayList<String>(0);
        this.modifiedList = modified;
        this.removedList = removed;
    }

    public Status getStatus() {
        return this.myStatus;
    }

    public List<String> getConflictList() {
        return this.conflictList;
    }

    public List<String> getUndeletedList() {
        return this.undeletedList;
    }

    public List<String> getModifiedList() {
        return this.modifiedList;
    }

    public List<String> getRemovedList() {
        return this.removedList;
    }

    public static enum Status {
        NOT_TRIED,
        OK,
        CONFLICTS,
        NONDELETED,
        ERROR;

    }
}

