/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.eclipse.jgit.lib;

import com.appland.shade.org.eclipse.jgit.lib.ConfigLine;
import com.appland.shade.org.eclipse.jgit.util.StringUtils;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ConfigSnapshot {
    final List<ConfigLine> entryList;
    final Map<Object, Object> cache;
    final ConfigSnapshot baseState;
    volatile List<ConfigLine> sorted;
    volatile SectionNames names;

    ConfigSnapshot(List<ConfigLine> entries, ConfigSnapshot base) {
        this.entryList = entries;
        this.cache = new ConcurrentHashMap<Object, Object>(16, 0.75f, 1);
        this.baseState = base;
    }

    Set<String> getSections() {
        return this.names().sections;
    }

    Set<String> getSubsections(String section) {
        Map<String, Set<String>> m = this.names().subsections;
        Set<String> r = m.get(section);
        if (r == null) {
            r = m.get(StringUtils.toLowerCase(section));
        }
        if (r == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(r);
    }

    Set<String> getNames(String section, String subsection) {
        return this.getNames(section, subsection, false);
    }

    Set<String> getNames(String section, String subsection, boolean recursive) {
        Map<String, String> m = this.getNamesInternal(section, subsection, recursive);
        return new CaseFoldingSet(m);
    }

    private Map<String, String> getNamesInternal(String section, String subsection, boolean recursive) {
        List<ConfigLine> s = this.sorted();
        int idx = this.find(s, section, subsection, "");
        if (idx < 0) {
            idx = -(idx + 1);
        }
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        while (idx < s.size()) {
            String l;
            ConfigLine e;
            if (!(e = s.get(idx++)).match(section, subsection)) break;
            if (e.name == null || m.containsKey(l = StringUtils.toLowerCase(e.name))) continue;
            m.put(l, e.name);
        }
        if (recursive && this.baseState != null) {
            m.putAll(this.baseState.getNamesInternal(section, subsection, recursive));
        }
        return m;
    }

    String[] get(String section, String subsection, String name) {
        List<ConfigLine> s = this.sorted();
        int idx = this.find(s, section, subsection, name);
        if (idx < 0) {
            return null;
        }
        int end = this.end(s, idx, section, subsection, name);
        String[] r = new String[end - idx];
        int i = 0;
        while (idx < end) {
            r[i++] = s.get((int)idx++).value;
        }
        return r;
    }

    private int find(List<ConfigLine> s, String s1, String s2, String name) {
        int low = 0;
        int high = s.size();
        while (low < high) {
            int mid = low + high >>> 1;
            ConfigLine e = s.get(mid);
            int cmp = ConfigSnapshot.compare2(s1, s2, name, e.section, e.subsection, e.name);
            if (cmp < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                return this.first(s, mid, s1, s2, name);
            }
            low = mid + 1;
        }
        return -(low + 1);
    }

    private int first(List<ConfigLine> s, int i, String s1, String s2, String n) {
        while (i > 0) {
            if (s.get(i - 1).match(s1, s2, n)) {
                --i;
                continue;
            }
            return i;
        }
        return i;
    }

    private int end(List<ConfigLine> s, int i, String s1, String s2, String n) {
        while (i < s.size()) {
            if (s.get(i).match(s1, s2, n)) {
                ++i;
                continue;
            }
            return i;
        }
        return i;
    }

    private List<ConfigLine> sorted() {
        List<ConfigLine> r = this.sorted;
        if (r == null) {
            this.sorted = r = ConfigSnapshot.sort(this.entryList);
        }
        return r;
    }

    private static List<ConfigLine> sort(List<ConfigLine> in) {
        ArrayList<ConfigLine> sorted = new ArrayList<ConfigLine>(in.size());
        for (ConfigLine line : in) {
            if (line.section == null || line.name == null) continue;
            sorted.add(line);
        }
        Collections.sort(sorted, new LineComparator());
        return sorted;
    }

    private static int compare2(String aSection, String aSubsection, String aName, String bSection, String bSubsection, String bName) {
        int c = StringUtils.compareIgnoreCase(aSection, bSection);
        if (c != 0) {
            return c;
        }
        if (aSubsection == null && bSubsection != null) {
            return -1;
        }
        if (aSubsection != null && bSubsection == null) {
            return 1;
        }
        if (aSubsection != null && (c = StringUtils.compareWithCase(aSubsection, bSubsection)) != 0) {
            return c;
        }
        return StringUtils.compareIgnoreCase(aName, bName);
    }

    private SectionNames names() {
        SectionNames n = this.names;
        if (n == null) {
            this.names = n = new SectionNames(this);
        }
        return n;
    }

    private static class CaseFoldingSet
    extends AbstractSet<String> {
        private final Map<String, String> names;

        CaseFoldingSet(Map<String, String> names) {
            this.names = names;
        }

        @Override
        public boolean contains(Object needle) {
            if (needle instanceof String) {
                String n = (String)needle;
                return this.names.containsKey(n) || this.names.containsKey(StringUtils.toLowerCase(n));
            }
            return false;
        }

        @Override
        public Iterator<String> iterator() {
            final Iterator<String> i = this.names.values().iterator();
            return new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public String next() {
                    return (String)i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.names.size();
        }
    }

    private static class LineComparator
    implements Comparator<ConfigLine> {
        private LineComparator() {
        }

        @Override
        public int compare(ConfigLine a, ConfigLine b) {
            return ConfigSnapshot.compare2(a.section, a.subsection, a.name, b.section, b.subsection, b.name);
        }
    }

    private static class SectionNames {
        final CaseFoldingSet sections;
        final Map<String, Set<String>> subsections;

        SectionNames(ConfigSnapshot cfg) {
            LinkedHashMap<String, String> sec = new LinkedHashMap<String, String>();
            HashMap<String, Set<String>> sub = new HashMap<String, Set<String>>();
            while (cfg != null) {
                for (ConfigLine e : cfg.entryList) {
                    if (e.section == null) continue;
                    String l1 = StringUtils.toLowerCase(e.section);
                    if (!sec.containsKey(l1)) {
                        sec.put(l1, e.section);
                    }
                    if (e.subsection == null) continue;
                    LinkedHashSet<String> m = (LinkedHashSet<String>)sub.get(l1);
                    if (m == null) {
                        m = new LinkedHashSet<String>();
                        sub.put(l1, m);
                    }
                    m.add(e.subsection);
                }
                cfg = cfg.baseState;
            }
            this.sections = new CaseFoldingSet(sec);
            this.subsections = sub;
        }
    }
}

