/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.core;

import com.appland.shade.org.tinylog.Level;
import com.appland.shade.org.tinylog.Supplier;
import com.appland.shade.org.tinylog.configuration.Configuration;
import com.appland.shade.org.tinylog.core.ConfigurationParser;
import com.appland.shade.org.tinylog.core.LogEntry;
import com.appland.shade.org.tinylog.core.LogEntryValue;
import com.appland.shade.org.tinylog.core.WritingThread;
import com.appland.shade.org.tinylog.format.MessageFormatter;
import com.appland.shade.org.tinylog.provider.ContextProvider;
import com.appland.shade.org.tinylog.runtime.RuntimeProvider;
import com.appland.shade.org.tinylog.runtime.Timestamp;
import com.appland.shade.org.tinylog.writers.Writer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class TinylogLoggingConfiguration {
    public Collection<Writer>[][] createWriters(List<String> tags, Level minimumLevel, boolean writingThread) {
        if (RuntimeProvider.getProcessId() == Long.MIN_VALUE) {
            ServiceLoader.load(Writer.class);
        }
        Collection[][] matrix = new Collection[tags.size() + 2][Level.values().length - 1];
        com.appland.shade.org.tinylog.configuration.ServiceLoader<Writer> loader = new com.appland.shade.org.tinylog.configuration.ServiceLoader<Writer>(Writer.class, Map.class);
        Map<String, String> writerProperties = Configuration.getSiblings("writer");
        if (writerProperties.isEmpty()) {
            writerProperties = Collections.singletonMap("writer", RuntimeProvider.getDefaultWriter());
        }
        for (Map.Entry<String, String> entry : writerProperties.entrySet()) {
            String[] tagArray;
            String exception;
            Map<String, String> configuration = Configuration.getChildren(entry.getKey());
            String tag = configuration.get("tag");
            Level level = ConfigurationParser.parse(configuration.get("level"), minimumLevel);
            if (level.ordinal() < minimumLevel.ordinal()) {
                level = minimumLevel;
            }
            if ((exception = Configuration.get("exception")) != null && !configuration.containsKey("exception")) {
                configuration.put("exception", exception);
            }
            configuration.put("ID", entry.getKey());
            configuration.put("writingthread", Boolean.toString(writingThread));
            Writer writer = loader.create(entry.getValue(), configuration);
            if (writer == null) continue;
            if (tag == null || tag.isEmpty()) {
                for (int tagIndex = 0; tagIndex < matrix.length; ++tagIndex) {
                    this.addWriter(writer, matrix, tagIndex, level);
                }
                continue;
            }
            if (tag.equals("-")) {
                this.addWriter(writer, matrix, 0, level);
                continue;
            }
            for (String tagArrayItem : tagArray = tag.split(",")) {
                Level currentLevel;
                String currentTag;
                String[] tagLevelItem = (tagArrayItem = tagArrayItem.trim()).split("@", 2);
                if (tagLevelItem.length == 1) {
                    currentTag = tagArrayItem;
                    currentLevel = level;
                } else {
                    currentTag = tagLevelItem[0].trim();
                    currentLevel = ConfigurationParser.parse(tagLevelItem[1].trim(), level);
                }
                if (tagArrayItem.isEmpty()) continue;
                this.addWriter(writer, matrix, tags.indexOf(currentTag) + 1, currentLevel);
            }
        }
        for (int tagIndex = 0; tagIndex < matrix.length; ++tagIndex) {
            for (int levelIndex = 0; levelIndex < matrix[tagIndex].length; ++levelIndex) {
                if (matrix[tagIndex][levelIndex] != null) continue;
                matrix[tagIndex][levelIndex] = Collections.emptyList();
            }
        }
        return matrix;
    }

    protected void addWriter(Writer writer, Collection<Writer>[][] matrix, int tagIndex, Level level) {
        for (int levelIndex = level.ordinal(); levelIndex < Level.OFF.ordinal(); ++levelIndex) {
            Collection<Writer> collection = matrix[tagIndex][levelIndex];
            if (collection == null) {
                matrix[tagIndex][levelIndex] = collection = new ArrayList<Writer>();
            }
            collection.add(writer);
        }
    }

    public Level calculateMinimumLevel(Level globalLevel, Map<String, Level> customLevels) {
        Level minimumLevel = globalLevel;
        for (Level level : customLevels.values()) {
            if (level.ordinal() >= minimumLevel.ordinal()) continue;
            minimumLevel = level;
        }
        return minimumLevel;
    }

    public Collection<LogEntryValue>[][] calculateRequiredLogEntryValues(Collection<Writer>[][] writers) {
        Collection[][] logEntryValues = new Collection[writers.length][Level.values().length - 1];
        for (int tagIndex = 0; tagIndex < writers.length; ++tagIndex) {
            for (int levelIndex = 0; levelIndex < Level.OFF.ordinal(); ++levelIndex) {
                EnumSet<LogEntryValue> values = EnumSet.noneOf(LogEntryValue.class);
                for (Writer writer : writers[tagIndex][levelIndex]) {
                    values.addAll(writer.getRequiredLogEntryValues());
                }
                logEntryValues[tagIndex][levelIndex] = values;
            }
        }
        return logEntryValues;
    }

    public BitSet calculateFullStackTraceRequirements(Collection<LogEntryValue>[][] logEntryValues) {
        BitSet result = new BitSet(logEntryValues.length);
        for (int i = 0; i < logEntryValues.length; ++i) {
            Collection<LogEntryValue> values = logEntryValues[i][Level.ERROR.ordinal()];
            if (!values.contains((Object)LogEntryValue.METHOD) && !values.contains((Object)LogEntryValue.FILE) && !values.contains((Object)LogEntryValue.LINE)) continue;
            result.set(i);
        }
        return result;
    }

    public WritingThread createWritingThread(Collection<Writer>[][] matrix) {
        Collection<Writer> writers = TinylogLoggingConfiguration.getAllWriters(matrix);
        WritingThread thread = new WritingThread(writers);
        thread.start();
        return thread;
    }

    public static Collection<Writer> getAllWriters(Collection<Writer>[][] matrix) {
        Set<Writer> writers = Collections.newSetFromMap(new IdentityHashMap());
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                writers.addAll(matrix[i][j]);
            }
        }
        return writers;
    }

    public static LogEntry createLogEntry(StackTraceElement stackTraceElement, String tag, Level level, Throwable exception, MessageFormatter formatter, Object obj, Object[] arguments, Collection<LogEntryValue>[] requiredLogEntryValues, ContextProvider contextProvider) {
        String message;
        int lineNumber;
        String fileName;
        String methodName;
        String className;
        Map<String, String> context;
        Collection<LogEntryValue> required = requiredLogEntryValues[level.ordinal()];
        Timestamp timestamp = RuntimeProvider.createTimestamp();
        Thread thread = required.contains((Object)LogEntryValue.THREAD) ? Thread.currentThread() : null;
        Map<String, String> map = context = required.contains((Object)LogEntryValue.CONTEXT) ? contextProvider.getMapping() : null;
        if (stackTraceElement == null) {
            className = null;
            methodName = null;
            fileName = null;
            lineNumber = -1;
        } else {
            className = stackTraceElement.getClassName();
            methodName = stackTraceElement.getMethodName();
            fileName = stackTraceElement.getFileName();
            lineNumber = stackTraceElement.getLineNumber();
        }
        if (arguments == null || arguments.length == 0) {
            Object evaluatedObject = obj instanceof Supplier ? ((Supplier)obj).get() : obj;
            message = evaluatedObject == null ? null : evaluatedObject.toString();
        } else {
            message = formatter.format((String)obj, arguments);
        }
        return new LogEntry(timestamp, thread, context, className, methodName, fileName, lineNumber, tag, level, message, exception);
    }
}

