/*
 * Decompiled with CFR 0.152.
 */
package com.appland.shade.org.tinylog.pattern;

import com.appland.shade.org.tinylog.core.LogEntry;
import com.appland.shade.org.tinylog.core.LogEntryValue;
import com.appland.shade.org.tinylog.pattern.Token;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.EnumSet;

final class BundleToken
implements Token {
    private final Token[] tokens;

    BundleToken(Collection<Token> tokens) {
        this.tokens = tokens.toArray(new Token[0]);
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        EnumSet<LogEntryValue> values = EnumSet.noneOf(LogEntryValue.class);
        for (Token token : this.tokens) {
            values.addAll(token.getRequiredLogEntryValues());
        }
        return values;
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        for (int i = 0; i < this.tokens.length; ++i) {
            this.tokens[i].render(logEntry, builder);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        StringBuilder builder = new StringBuilder();
        this.render(logEntry, builder);
        statement.setString(index, builder.toString());
    }
}

