/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaboration;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxCollection;
import com.box.sdk.BoxDateFormat;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFileUploadSession;
import com.box.sdk.BoxGroup;
import com.box.sdk.BoxItem;
import com.box.sdk.BoxItemIterator;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxMetadataCascadePolicy;
import com.box.sdk.BoxMultipartRequest;
import com.box.sdk.BoxResource;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxSharedLink;
import com.box.sdk.BoxUploadEmail;
import com.box.sdk.BoxUser;
import com.box.sdk.BoxWatermark;
import com.box.sdk.BoxWebHook;
import com.box.sdk.BoxWebLink;
import com.box.sdk.FileUploadParams;
import com.box.sdk.LargeFileUpload;
import com.box.sdk.Metadata;
import com.box.sdk.PartialCollection;
import com.box.sdk.ProgressListener;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.box.sdk.UploadFileCallback;
import com.box.sdk.internal.utils.Parsers;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BoxResourceType(value="folder")
public class BoxFolder
extends BoxItem
implements Iterable<BoxItem.Info> {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "sequence_id", "etag", "name", "created_at", "modified_at", "description", "size", "path_collection", "created_by", "modified_by", "trashed_at", "purged_at", "content_created_at", "content_modified_at", "owned_by", "shared_link", "folder_upload_email", "parent", "item_status", "item_collection", "sync_state", "has_collaborations", "permissions", "tags", "can_non_owners_invite", "collections", "watermark_info", "metadata"};
    public static final URLTemplate CREATE_FOLDER_URL = new URLTemplate("folders");
    public static final URLTemplate CREATE_WEB_LINK_URL = new URLTemplate("web_links");
    public static final URLTemplate COPY_FOLDER_URL = new URLTemplate("folders/%s/copy");
    public static final URLTemplate DELETE_FOLDER_URL = new URLTemplate("folders/%s?recursive=%b");
    public static final URLTemplate FOLDER_INFO_URL_TEMPLATE = new URLTemplate("folders/%s");
    public static final URLTemplate UPLOAD_FILE_URL = new URLTemplate("files/content");
    public static final URLTemplate ADD_COLLABORATION_URL = new URLTemplate("collaborations");
    public static final URLTemplate GET_COLLABORATIONS_URL = new URLTemplate("folders/%s/collaborations");
    public static final URLTemplate GET_ITEMS_URL = new URLTemplate("folders/%s/items/");
    public static final URLTemplate SEARCH_URL_TEMPLATE = new URLTemplate("search");
    public static final URLTemplate METADATA_URL_TEMPLATE = new URLTemplate("folders/%s/metadata/%s/%s");
    public static final URLTemplate UPLOAD_SESSION_URL_TEMPLATE = new URLTemplate("files/upload_sessions");

    public BoxFolder(BoxAPIConnection api, String id) {
        super(api, id);
    }

    @Override
    protected URL getItemURL() {
        return FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
    }

    public static BoxFolder getRootFolder(BoxAPIConnection api) {
        return new BoxFolder(api, "0");
    }

    public BoxCollaboration.Info collaborate(BoxCollaborator collaborator, BoxCollaboration.Role role) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("id", collaborator.getID());
        if (collaborator instanceof BoxUser) {
            accessibleByField.add("type", "user");
        } else if (collaborator instanceof BoxGroup) {
            accessibleByField.add("type", "group");
        } else {
            throw new IllegalArgumentException("The given collaborator is of an unknown type.");
        }
        return this.collaborate(accessibleByField, role, null, null);
    }

    public BoxCollaboration.Info collaborate(String email, BoxCollaboration.Role role) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("login", email);
        accessibleByField.add("type", "user");
        return this.collaborate(accessibleByField, role, null, null);
    }

    public BoxCollaboration.Info collaborate(BoxCollaborator collaborator, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("id", collaborator.getID());
        if (collaborator instanceof BoxUser) {
            accessibleByField.add("type", "user");
        } else if (collaborator instanceof BoxGroup) {
            accessibleByField.add("type", "group");
        } else {
            throw new IllegalArgumentException("The given collaborator is of an unknown type.");
        }
        return this.collaborate(accessibleByField, role, notify, canViewPath);
    }

    public BoxCollaboration.Info collaborate(String email, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath) {
        JsonObject accessibleByField = new JsonObject();
        accessibleByField.add("login", email);
        accessibleByField.add("type", "user");
        return this.collaborate(accessibleByField, role, notify, canViewPath);
    }

    private BoxCollaboration.Info collaborate(JsonObject accessibleByField, BoxCollaboration.Role role, Boolean notify, Boolean canViewPath) {
        JsonObject itemField = new JsonObject();
        itemField.add("id", this.getID());
        itemField.add("type", "folder");
        return BoxCollaboration.create(this.getAPI(), accessibleByField, itemField, role, notify, canViewPath);
    }

    @Override
    public BoxSharedLink createSharedLink(BoxSharedLink.Access access, Date unshareDate, BoxSharedLink.Permissions permissions) {
        BoxSharedLink sharedLink = new BoxSharedLink(access, unshareDate, permissions);
        Info info = new Info();
        info.setSharedLink(sharedLink);
        this.updateInfo(info);
        return info.getSharedLink();
    }

    public BoxSharedLink createSharedLink(BoxSharedLink.Access access, Date unshareDate, BoxSharedLink.Permissions permissions, String password) {
        BoxSharedLink sharedLink = new BoxSharedLink(access, unshareDate, permissions, password);
        Info info = new Info();
        info.setSharedLink(sharedLink);
        this.updateInfo(info);
        return info.getSharedLink();
    }

    public Collection<BoxCollaboration.Info> getCollaborations() {
        BoxAPIConnection api = this.getAPI();
        URL url = GET_COLLABORATIONS_URL.build(api.getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        int entriesCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxCollaboration.Info> collaborations = new ArrayList<BoxCollaboration.Info>(entriesCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxCollaboration collaboration;
            JsonObject entryObject = entry.asObject();
            BoxCollaboration boxCollaboration = collaboration = new BoxCollaboration(api, entryObject.get("id").asString());
            boxCollaboration.getClass();
            BoxCollaboration.Info info = boxCollaboration.new BoxCollaboration.Info(entryObject);
            collaborations.add(info);
        }
        return collaborations;
    }

    @Override
    public Info getInfo() {
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(response.getJSON());
    }

    @Override
    public Info getInfo(String ... fields) {
        String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
        URL url = FOLDER_INFO_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Info(response.getJSON());
    }

    public void updateInfo(Info info) {
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
    }

    @Override
    public Info copy(BoxFolder destination) {
        return this.copy(destination, null);
    }

    @Override
    public Info copy(BoxFolder destination, String newName) {
        BoxFolder copiedFolder;
        URL url = COPY_FOLDER_URL.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject copyInfo = new JsonObject();
        copyInfo.add("parent", (JsonValue)parent);
        if (newName != null) {
            copyInfo.add("name", newName);
        }
        request.setBody(copyInfo.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxFolder boxFolder = copiedFolder = new BoxFolder(this.getAPI(), responseJSON.get("id").asString());
        boxFolder.getClass();
        return boxFolder.new Info(responseJSON);
    }

    public Info createFolder(String name) {
        BoxFolder createdFolder;
        JsonObject parent = new JsonObject();
        parent.add("id", this.getID());
        JsonObject newFolder = new JsonObject();
        newFolder.add("name", name);
        newFolder.add("parent", (JsonValue)parent);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), CREATE_FOLDER_URL.build(this.getAPI().getBaseURL(), new Object[0]), "POST");
        request.setBody(newFolder.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxFolder boxFolder = createdFolder = new BoxFolder(this.getAPI(), responseJSON.get("id").asString());
        boxFolder.getClass();
        return boxFolder.new Info(responseJSON);
    }

    public void delete(boolean recursive) {
        URL url = DELETE_FOLDER_URL.build(this.getAPI().getBaseURL(), this.getID(), recursive);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    @Override
    public BoxItem.Info move(BoxFolder destination) {
        return this.move(destination, null);
    }

    @Override
    public BoxItem.Info move(BoxFolder destination, String newName) {
        BoxFolder movedFolder;
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject parent = new JsonObject();
        parent.add("id", destination.getID());
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("parent", (JsonValue)parent);
        if (newName != null) {
            updateInfo.add("name", newName);
        }
        request.setBody(updateInfo.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxFolder boxFolder = movedFolder = new BoxFolder(this.getAPI(), responseJSON.get("id").asString());
        boxFolder.getClass();
        return boxFolder.new Info(responseJSON);
    }

    public void rename(String newName) {
        URL url = FOLDER_INFO_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject updateInfo = new JsonObject();
        updateInfo.add("name", newName);
        request.setBody(updateInfo.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        response.getJSON();
    }

    public void canUpload(String name, long fileSize) {
        URL url = UPLOAD_FILE_URL.build(this.getAPI().getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "OPTIONS");
        JsonObject parent = new JsonObject();
        parent.add("id", this.getID());
        JsonObject preflightInfo = new JsonObject();
        preflightInfo.add("parent", (JsonValue)parent);
        preflightInfo.add("name", name);
        preflightInfo.add("size", fileSize);
        request.setBody(preflightInfo.toString());
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public BoxFile.Info uploadFile(InputStream fileContent, String name) {
        FileUploadParams uploadInfo = new FileUploadParams().setContent(fileContent).setName(name);
        return this.uploadFile(uploadInfo);
    }

    public BoxFile.Info uploadFile(UploadFileCallback callback, String name) {
        FileUploadParams uploadInfo = new FileUploadParams().setUploadFileCallback(callback).setName(name);
        return this.uploadFile(uploadInfo);
    }

    public BoxFile.Info uploadFile(InputStream fileContent, String name, long fileSize, ProgressListener listener) {
        FileUploadParams uploadInfo = new FileUploadParams().setContent(fileContent).setName(name).setSize(fileSize).setProgressListener(listener);
        return this.uploadFile(uploadInfo);
    }

    public BoxFile.Info uploadFile(InputStream fileContent, String name, String description) {
        FileUploadParams uploadInfo = new FileUploadParams().setContent(fileContent).setName(name).setDescription(description);
        return this.uploadFile(uploadInfo);
    }

    public BoxFile.Info uploadFile(FileUploadParams uploadParams) {
        BoxFile uploadedFile;
        URL uploadURL = UPLOAD_FILE_URL.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        BoxMultipartRequest request = new BoxMultipartRequest(this.getAPI(), uploadURL);
        JsonObject fieldJSON = new JsonObject();
        JsonObject parentIdJSON = new JsonObject();
        parentIdJSON.add("id", this.getID());
        fieldJSON.add("name", uploadParams.getName());
        fieldJSON.add("parent", (JsonValue)parentIdJSON);
        if (uploadParams.getCreated() != null) {
            fieldJSON.add("content_created_at", BoxDateFormat.format(uploadParams.getCreated()));
        }
        if (uploadParams.getModified() != null) {
            fieldJSON.add("content_modified_at", BoxDateFormat.format(uploadParams.getModified()));
        }
        if (uploadParams.getSHA1() != null && !uploadParams.getSHA1().isEmpty()) {
            request.setContentSHA1(uploadParams.getSHA1());
        }
        if (uploadParams.getDescription() != null) {
            fieldJSON.add("description", uploadParams.getDescription());
        }
        request.putField("attributes", fieldJSON.toString());
        if (uploadParams.getSize() > 0L) {
            request.setFile(uploadParams.getContent(), uploadParams.getName(), uploadParams.getSize());
        } else if (uploadParams.getContent() != null) {
            request.setFile(uploadParams.getContent(), uploadParams.getName());
        } else {
            request.setUploadFileCallback(uploadParams.getUploadFileCallback(), uploadParams.getName());
        }
        BoxJSONResponse response = uploadParams.getProgressListener() == null ? (BoxJSONResponse)request.send() : (BoxJSONResponse)request.send(uploadParams.getProgressListener());
        JsonObject collection = JsonObject.readFrom((String)response.getJSON());
        JsonArray entries = collection.get("entries").asArray();
        JsonObject fileInfoJSON = entries.get(0).asObject();
        String uploadedFileID = fileInfoJSON.get("id").asString();
        BoxFile boxFile = uploadedFile = new BoxFile(this.getAPI(), uploadedFileID);
        boxFile.getClass();
        return boxFile.new BoxFile.Info(fileInfoJSON);
    }

    public BoxWebLink.Info createWebLink(URL linkURL) {
        return this.createWebLink(null, linkURL, null);
    }

    public BoxWebLink.Info createWebLink(String name, URL linkURL) {
        return this.createWebLink(name, linkURL, null);
    }

    public BoxWebLink.Info createWebLink(URL linkURL, String description) {
        return this.createWebLink(null, linkURL, description);
    }

    public BoxWebLink.Info createWebLink(String name, URL linkURL, String description) {
        BoxWebLink createdWebLink;
        JsonObject parent = new JsonObject();
        parent.add("id", this.getID());
        JsonObject newWebLink = new JsonObject();
        newWebLink.add("name", name);
        newWebLink.add("parent", (JsonValue)parent);
        newWebLink.add("url", linkURL.toString());
        if (description != null) {
            newWebLink.add("description", description);
        }
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), CREATE_WEB_LINK_URL.build(this.getAPI().getBaseURL(), new Object[0]), "POST");
        request.setBody(newWebLink.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxWebLink boxWebLink = createdWebLink = new BoxWebLink(this.getAPI(), responseJSON.get("id").asString());
        boxWebLink.getClass();
        return new BoxWebLink.Info(boxWebLink, responseJSON);
    }

    public Iterable<BoxItem.Info> getChildren() {
        return this;
    }

    public Iterable<BoxItem.Info> getChildren(final String ... fields) {
        return new Iterable<BoxItem.Info>(){

            @Override
            public Iterator<BoxItem.Info> iterator() {
                String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
                URL url = GET_ITEMS_URL.buildWithQuery(BoxFolder.this.getAPI().getBaseURL(), queryString, BoxFolder.this.getID());
                return new BoxItemIterator(BoxFolder.this.getAPI(), url);
            }
        };
    }

    public Iterable<BoxItem.Info> getChildren(String sort, SortDirection direction, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder().appendParam("sort", sort).appendParam("direction", direction.toString());
        if (fields.length > 0) {
            builder.appendParam("fields", fields).toString();
        }
        final String query = builder.toString();
        return new Iterable<BoxItem.Info>(){

            @Override
            public Iterator<BoxItem.Info> iterator() {
                URL url = GET_ITEMS_URL.buildWithQuery(BoxFolder.this.getAPI().getBaseURL(), query, BoxFolder.this.getID());
                return new BoxItemIterator(BoxFolder.this.getAPI(), url);
            }
        };
    }

    public PartialCollection<BoxItem.Info> getChildrenRange(long offset, long limit, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder().appendParam("limit", limit).appendParam("offset", offset);
        if (fields.length > 0) {
            builder.appendParam("fields", fields).toString();
        }
        URL url = GET_ITEMS_URL.buildWithQuery(this.getAPI().getBaseURL(), builder.toString(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        String totalCountString = responseJSON.get("total_count").toString();
        long fullSize = Double.valueOf(totalCountString).longValue();
        PartialCollection<BoxItem.Info> children = new PartialCollection<BoxItem.Info>(offset, limit, fullSize);
        JsonArray jsonArray = responseJSON.get("entries").asArray();
        for (JsonValue value : jsonArray) {
            JsonObject jsonObject = value.asObject();
            BoxItem.Info parsedItemInfo = (BoxItem.Info)BoxResource.parseInfo(this.getAPI(), jsonObject);
            if (parsedItemInfo == null) continue;
            children.add(parsedItemInfo);
        }
        return children;
    }

    @Override
    public Iterator<BoxItem.Info> iterator() {
        URL url = GET_ITEMS_URL.build(this.getAPI().getBaseURL(), this.getID());
        return new BoxItemIterator(this.getAPI(), url);
    }

    public BoxWebHook.Info addWebHook(URL address, BoxWebHook.Trigger ... triggers) {
        return BoxWebHook.create((BoxResource)this, address, triggers);
    }

    public BoxWatermark getWatermark(String ... fields) {
        return this.getWatermark(FOLDER_INFO_URL_TEMPLATE, fields);
    }

    public BoxWatermark applyWatermark() {
        return this.applyWatermark(FOLDER_INFO_URL_TEMPLATE, "default");
    }

    public void removeWatermark() {
        this.removeWatermark(FOLDER_INFO_URL_TEMPLATE);
    }

    public Iterable<Metadata> getAllMetadata(String ... fields) {
        return Metadata.getAllMetadata(this, fields);
    }

    @Deprecated
    public Iterable<BoxItem.Info> search(final String query) {
        return new Iterable<BoxItem.Info>(){

            @Override
            public Iterator<BoxItem.Info> iterator() {
                QueryStringBuilder builder = new QueryStringBuilder();
                builder.appendParam("query", query);
                builder.appendParam("ancestor_folder_ids", BoxFolder.this.getID());
                URL url = SEARCH_URL_TEMPLATE.buildWithQuery(BoxFolder.this.getAPI().getBaseURL(), builder.toString(), new Object[0]);
                return new BoxItemIterator(BoxFolder.this.getAPI(), url);
            }
        };
    }

    @Override
    public Info setCollections(BoxCollection ... collections) {
        JsonArray jsonArray = new JsonArray();
        for (BoxCollection collection : collections) {
            JsonObject collectionJSON = new JsonObject();
            collectionJSON.add("id", collection.getID());
            jsonArray.add((JsonValue)collectionJSON);
        }
        JsonObject infoJSON = new JsonObject();
        infoJSON.add("collections", (JsonValue)jsonArray);
        String queryString = new QueryStringBuilder().appendParam("fields", ALL_FIELDS).toString();
        URL url = FOLDER_INFO_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(infoJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        return new Info(jsonObject);
    }

    public Metadata createMetadata(Metadata metadata) {
        return this.createMetadata("properties", metadata);
    }

    public Metadata createMetadata(String templateName, Metadata metadata) {
        String scope = Metadata.scopeBasedOnType(templateName);
        return this.createMetadata(templateName, scope, metadata);
    }

    public Metadata createMetadata(String templateName, String scope, Metadata metadata) {
        URL url = METADATA_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), scope, templateName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "POST");
        request.addHeader("Content-Type", "application/json");
        request.setBody(metadata.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Metadata(JsonObject.readFrom((String)response.getJSON()));
    }

    public Metadata setMetadata(String templateName, String scope, Metadata metadata) {
        Metadata metadataValue;
        block6: {
            metadataValue = null;
            try {
                metadataValue = this.createMetadata(templateName, scope, metadata);
            }
            catch (BoxAPIException e) {
                if (e.getResponseCode() != 409) break block6;
                Metadata metadataToUpdate = new Metadata(scope, templateName);
                for (JsonValue value : metadata.getOperations()) {
                    if (value.asObject().get("value").isNumber()) {
                        metadataToUpdate.add(value.asObject().get("path").asString(), value.asObject().get("value").asFloat());
                        continue;
                    }
                    if (value.asObject().get("value").isString()) {
                        metadataToUpdate.add(value.asObject().get("path").asString(), value.asObject().get("value").asString());
                        continue;
                    }
                    if (!value.asObject().get("value").isArray()) continue;
                    ArrayList<String> list = new ArrayList<String>();
                    for (JsonValue jsonValue : value.asObject().get("value").asArray()) {
                        list.add(jsonValue.asString());
                    }
                    metadataToUpdate.add(value.asObject().get("path").asString(), list);
                }
                metadataValue = this.updateMetadata(metadataToUpdate);
            }
        }
        return metadataValue;
    }

    public Metadata getMetadata() {
        return this.getMetadata("properties");
    }

    public Metadata getMetadata(String templateName) {
        String scope = Metadata.scopeBasedOnType(templateName);
        return this.getMetadata(templateName, scope);
    }

    public Metadata getMetadata(String templateName, String scope) {
        URL url = METADATA_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), scope, templateName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Metadata(JsonObject.readFrom((String)response.getJSON()));
    }

    public Metadata updateMetadata(Metadata metadata) {
        URL url = METADATA_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), metadata.getScope(), metadata.getTemplateName());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "PUT");
        request.addHeader("Content-Type", "application/json-patch+json");
        request.setBody(metadata.getPatch());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        return new Metadata(JsonObject.readFrom((String)response.getJSON()));
    }

    public void deleteMetadata() {
        this.deleteMetadata("properties");
    }

    public void deleteMetadata(String templateName) {
        String scope = Metadata.scopeBasedOnType(templateName);
        this.deleteMetadata(templateName, scope);
    }

    public void deleteMetadata(String templateName, String scope) {
        URL url = METADATA_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), scope, templateName);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public String addClassification(String classificationType) {
        Metadata metadata = new Metadata().add("/Box__Security__Classification__Key", classificationType);
        Metadata classification = this.createMetadata("securityClassification-6VMVochwUWo", "enterprise", metadata);
        return classification.getString("/Box__Security__Classification__Key");
    }

    public String updateClassification(String classificationType) {
        Metadata metadata = new Metadata("enterprise", "securityClassification-6VMVochwUWo");
        metadata.replace("/Box__Security__Classification__Key", classificationType);
        Metadata classification = this.updateMetadata(metadata);
        return classification.getString("/Box__Security__Classification__Key");
    }

    public String setClassification(String classificationType) {
        Metadata metadata = new Metadata().add("/Box__Security__Classification__Key", classificationType);
        Metadata classification = null;
        try {
            classification = this.createMetadata("securityClassification-6VMVochwUWo", "enterprise", metadata);
        }
        catch (BoxAPIException e) {
            if (e.getResponseCode() == 409) {
                metadata = new Metadata("enterprise", "securityClassification-6VMVochwUWo");
                metadata.replace("/Box__Security__Classification__Key", classificationType);
                classification = this.updateMetadata(metadata);
            }
            throw e;
        }
        return classification.getString("/Box__Security__Classification__Key");
    }

    public String getClassification() {
        Metadata metadata = this.getMetadata("securityClassification-6VMVochwUWo");
        return metadata.getString("/Box__Security__Classification__Key");
    }

    public void deleteClassification() {
        this.deleteMetadata("securityClassification-6VMVochwUWo", "enterprise");
    }

    public BoxFileUploadSession.Info createUploadSession(String fileName, long fileSize) {
        BoxFileUploadSession session;
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        JsonObject body = new JsonObject();
        body.add("folder_id", this.getID());
        body.add("file_name", fileName);
        body.add("file_size", fileSize);
        request.setBody(body.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        String sessionId = jsonObject.get("id").asString();
        BoxFileUploadSession boxFileUploadSession = session = new BoxFileUploadSession(this.getAPI(), sessionId);
        boxFileUploadSession.getClass();
        return boxFileUploadSession.new BoxFileUploadSession.Info(jsonObject);
    }

    public BoxFile.Info uploadLargeFile(InputStream inputStream, String fileName, long fileSize) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        return new LargeFileUpload().upload(this.getAPI(), this.getID(), inputStream, url, fileName, fileSize);
    }

    public BoxFile.Info uploadLargeFile(InputStream inputStream, String fileName, long fileSize, int nParallelConnections, long timeOut, TimeUnit unit) throws InterruptedException, IOException {
        URL url = UPLOAD_SESSION_URL_TEMPLATE.build(this.getAPI().getBaseUploadURL(), new Object[0]);
        return new LargeFileUpload(nParallelConnections, timeOut, unit).upload(this.getAPI(), this.getID(), inputStream, url, fileName, fileSize);
    }

    public BoxMetadataCascadePolicy.Info addMetadataCascadePolicy(String scope, String templateKey) {
        return BoxMetadataCascadePolicy.create(this.getAPI(), this.getID(), scope, templateKey);
    }

    public Iterable<BoxMetadataCascadePolicy.Info> getMetadataCascadePolicies(String ... fields) {
        Iterable<BoxMetadataCascadePolicy.Info> cascadePoliciesInfo = BoxMetadataCascadePolicy.getAll(this.getAPI(), this.getID(), fields);
        return cascadePoliciesInfo;
    }

    public Iterable<BoxMetadataCascadePolicy.Info> getMetadataCascadePolicies(String enterpriseID, int limit, String ... fields) {
        Iterable<BoxMetadataCascadePolicy.Info> cascadePoliciesInfo = BoxMetadataCascadePolicy.getAll(this.getAPI(), this.getID(), enterpriseID, limit, fields);
        return cascadePoliciesInfo;
    }

    public static enum Permission {
        CAN_DOWNLOAD("can_download"),
        CAN_UPLOAD("can_upload"),
        CAN_RENAME("can_rename"),
        CAN_DELETE("can_delete"),
        CAN_SHARE("can_share"),
        CAN_INVITE_COLLABORATOR("can_invite_collaborator"),
        CAN_SET_SHARE_ACCESS("can_set_share_access");

        private final String jsonValue;

        private Permission(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Permission fromJSONValue(String jsonValue) {
            return Permission.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public static enum SyncState {
        SYNCED("synced"),
        NOT_SYNCED("not_synced"),
        PARTIALLY_SYNCED("partially_synced");

        private final String jsonValue;

        private SyncState(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static SyncState fromJSONValue(String jsonValue) {
            return SyncState.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public class Info
    extends BoxItem.Info {
        private BoxUploadEmail uploadEmail;
        private boolean hasCollaborations;
        private SyncState syncState;
        private EnumSet<Permission> permissions;
        private boolean canNonOwnersInvite;
        private boolean isWatermarked;
        private boolean isCollaborationRestrictedToEnterprise;
        private Map<String, Map<String, Metadata>> metadataMap;

        public Info() {
            super(BoxFolder.this);
        }

        public Info(String json) {
            super((BoxItem)BoxFolder.this, json);
        }

        public Info(JsonObject jsonObject) {
            super((BoxItem)BoxFolder.this, jsonObject);
        }

        public BoxUploadEmail getUploadEmail() {
            return this.uploadEmail;
        }

        public void setUploadEmail(BoxUploadEmail uploadEmail) {
            if (this.uploadEmail == uploadEmail) {
                return;
            }
            this.removeChildObject("folder_upload_email");
            this.uploadEmail = uploadEmail;
            if (uploadEmail == null) {
                this.addPendingChange("folder_upload_email", (String)null);
            } else {
                this.addChildObject("folder_upload_email", uploadEmail);
            }
        }

        public boolean getHasCollaborations() {
            return this.hasCollaborations;
        }

        public SyncState getSyncState() {
            return this.syncState;
        }

        public void setSyncState(SyncState syncState) {
            this.syncState = syncState;
            this.addPendingChange("sync_state", syncState.toJSONValue());
        }

        public EnumSet<Permission> getPermissions() {
            return this.permissions;
        }

        public boolean getCanNonOwnersInvite() {
            return this.canNonOwnersInvite;
        }

        public boolean getIsCollaborationRestrictedToEnterprise() {
            return this.isCollaborationRestrictedToEnterprise;
        }

        public void setIsCollaborationRestrictedToEnterprise(boolean isRestricted) {
            this.isCollaborationRestrictedToEnterprise = isRestricted;
            this.addPendingChange("is_collaboration_restricted_to_enterprise", isRestricted);
        }

        public boolean getIsWatermarked() {
            return this.isWatermarked;
        }

        public Metadata getMetadata(String templateName, String scope) {
            try {
                return this.metadataMap.get(scope).get(templateName);
            }
            catch (NullPointerException e) {
                return null;
            }
        }

        @Override
        public BoxFolder getResource() {
            return BoxFolder.this;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            String memberName = member.getName();
            JsonValue value = member.getValue();
            if (memberName.equals("folder_upload_email")) {
                if (this.uploadEmail == null) {
                    this.uploadEmail = new BoxUploadEmail(value.asObject());
                } else {
                    this.uploadEmail.update(value.asObject());
                }
            } else if (memberName.equals("has_collaborations")) {
                this.hasCollaborations = value.asBoolean();
            } else if (memberName.equals("sync_state")) {
                this.syncState = SyncState.fromJSONValue(value.asString());
            } else if (memberName.equals("permissions")) {
                this.permissions = this.parsePermissions(value.asObject());
            } else if (memberName.equals("can_non_owners_invite")) {
                this.canNonOwnersInvite = value.asBoolean();
            } else if (memberName.equals("is_collaboration_restricted_to_enterprise")) {
                this.isCollaborationRestrictedToEnterprise = value.asBoolean();
            } else if (memberName.equals("watermark_info")) {
                JsonObject jsonObject = value.asObject();
                this.isWatermarked = jsonObject.get("is_watermarked").asBoolean();
            } else if (memberName.equals("metadata")) {
                JsonObject jsonObject = value.asObject();
                this.metadataMap = Parsers.parseAndPopulateMetadataMap(jsonObject);
            }
        }

        private EnumSet<Permission> parsePermissions(JsonObject jsonObject) {
            EnumSet<Permission> permissions = EnumSet.noneOf(Permission.class);
            for (JsonObject.Member member : jsonObject) {
                JsonValue value = member.getValue();
                if (value.isNull() || !value.asBoolean()) continue;
                String memberName = member.getName();
                if (memberName.equals("can_download")) {
                    permissions.add(Permission.CAN_DOWNLOAD);
                    continue;
                }
                if (memberName.equals("can_upload")) {
                    permissions.add(Permission.CAN_UPLOAD);
                    continue;
                }
                if (memberName.equals("can_rename")) {
                    permissions.add(Permission.CAN_RENAME);
                    continue;
                }
                if (memberName.equals("can_delete")) {
                    permissions.add(Permission.CAN_DELETE);
                    continue;
                }
                if (memberName.equals("can_share")) {
                    permissions.add(Permission.CAN_SHARE);
                    continue;
                }
                if (memberName.equals("can_invite_collaborator")) {
                    permissions.add(Permission.CAN_INVITE_COLLABORATOR);
                    continue;
                }
                if (!memberName.equals("can_set_share_access")) continue;
                permissions.add(Permission.CAN_SET_SHARE_ACCESS);
            }
            return permissions;
        }
    }

    public static enum SortDirection {
        ASC,
        DESC;

    }
}

