/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAIAgentAsk;
import com.box.sdk.BoxAIAgentExtract;
import com.box.sdk.BoxAIAgentExtractStructured;
import com.box.sdk.BoxAIAgentTextGen;
import com.box.sdk.BoxJSONObject;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;

public abstract class BoxAIAgent
extends BoxJSONObject {
    private String type;

    public BoxAIAgent(String type) {
        this.type = type;
    }

    public BoxAIAgent(JsonObject jsonObject) {
        super(jsonObject);
    }

    public static BoxAIAgent parse(JsonObject jsonObject) {
        String type = jsonObject.get("type").asString();
        if (type.equals("ai_agent_ask")) {
            return new BoxAIAgentAsk(jsonObject);
        }
        if (type.equals("ai_agent_text_gen")) {
            return new BoxAIAgentTextGen(jsonObject);
        }
        if (type.equals("ai_agent_extract")) {
            return new BoxAIAgentExtract(jsonObject);
        }
        if (type.equals("ai_agent_extract_structured")) {
            return new BoxAIAgentExtractStructured(jsonObject);
        }
        throw new IllegalArgumentException("Invalid AI agent type: " + type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    void parseJSONMember(JsonObject.Member member) {
        super.parseJSONMember(member);
        String memberName = member.getName();
        JsonValue value = member.getValue();
        if (memberName.equals("type")) {
            this.type = value.asString();
        }
    }

    public JsonObject getJSONObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("type", this.type);
        return jsonObject;
    }

    public static enum Mode {
        ASK("ask"),
        TEXT_GEN("text_gen"),
        EXTRACT("extract"),
        EXTRACT_STRUCTURED("extract_structured");

        private final String value;

        private Mode(String value) {
            this.value = value;
        }

        static Mode fromJSONValue(String value) {
            if (value.equals("ask")) {
                return ASK;
            }
            if (value.equals("text_gen")) {
                return TEXT_GEN;
            }
            if (value.equals("extract")) {
                return EXTRACT;
            }
            if (value.equals("extract_structured")) {
                return EXTRACT_STRUCTURED;
            }
            throw new IllegalArgumentException("Invalid AI agent mode: " + value);
        }

        String toJSONValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }
}

