/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk.internal.pool;

import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.crypto.Mac;

public class MacPool {
    private final Map<String, Queue<Mac>> macPoolByAlgorithm = new ConcurrentHashMap<String, Queue<Mac>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mac acquire(String algorithm) {
        Mac result = null;
        Queue<Mac> pool = this.macPoolByAlgorithm.get(algorithm);
        if (pool != null) {
            result = pool.poll();
        }
        if (result != null) {
            Mac mac = result;
            synchronized (mac) {
                result.reset();
            }
            return result;
        }
        try {
            return Mac.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(String.format("NoSuchAlgorithm '%s':", algorithm), e);
        }
    }

    public void release(Mac mac) {
        Queue<Mac> pool = this.macPoolByAlgorithm.get(mac.getAlgorithm());
        if (pool == null) {
            pool = new LinkedBlockingQueue<Mac>();
            this.macPoolByAlgorithm.put(mac.getAlgorithm(), pool);
        }
        pool.offer(mac);
    }
}

