/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.ClientTokenOptionsRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import java.util.ArrayList;

public class ClientTokenRequest
extends Request {
    private static final int DEFAULT_VERSION = 2;
    private String customerId;
    private ArrayList<String> domains;
    private String merchantAccountId;
    private ClientTokenOptionsRequest optionsRequest;
    private int version;

    public String getCustomerId() {
        return this.customerId;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public ClientTokenOptionsRequest getOptions() {
        return this.optionsRequest;
    }

    public ClientTokenRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public ClientTokenRequest domains(ArrayList<String> domains) {
        this.domains = domains;
        return this;
    }

    public ClientTokenRequest merchantAccountId(String merchantAccountId) {
        this.merchantAccountId = merchantAccountId;
        return this;
    }

    public ClientTokenRequest options(ClientTokenOptionsRequest optionsRequest) {
        this.optionsRequest = optionsRequest;
        return this;
    }

    public ClientTokenRequest version(int version) {
        this.version = version;
        return this;
    }

    @Override
    public String toXML() {
        return this.buildRequest("clientToken").toXML();
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root);
        if (this.customerId != null) {
            builder.addElement("customerId", this.customerId);
        }
        if (this.domains != null) {
            builder.addElement("domains", this.domains);
        }
        if (this.merchantAccountId != null) {
            builder.addElement("merchantAccountId", this.merchantAccountId);
        }
        if (this.optionsRequest != null) {
            builder.addElement("options", this.optionsRequest);
        }
        if (this.version != 0) {
            builder.addElement("version", this.version);
        } else {
            builder.addElement("version", 2);
        }
        return builder;
    }
}

