/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.MerchantAccount;
import com.braintreegateway.ResourceCollection;
import com.braintreegateway.Transaction;
import com.braintreegateway.TransactionSearchRequest;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Disbursement {
    private final String id;
    private final String exceptionMessage;
    private final Calendar disbursementDate;
    private final DisbursementType disbursementType;
    private final String followUpAction;
    private final List<String> transactionIds;
    private final Boolean success;
    private final Boolean retry;
    private final BigDecimal amount;
    private MerchantAccount merchantAccount;

    public Disbursement(NodeWrapper node) {
        this.id = node.findString("id");
        this.exceptionMessage = node.findString("exception-message");
        this.disbursementDate = node.findDate("disbursement-date");
        this.followUpAction = node.findString("follow-up-action");
        this.success = node.findBoolean("success");
        this.retry = node.findBoolean("retry");
        this.amount = node.findBigDecimal("amount");
        this.merchantAccount = new MerchantAccount(node.findFirst("merchant-account"));
        this.transactionIds = new ArrayList<String>();
        for (NodeWrapper transactionIdNode : node.findAll("transaction-ids/item")) {
            this.transactionIds.add(transactionIdNode.findString("."));
        }
        String dType = node.findString("disbursement-type");
        this.disbursementType = dType == null ? DisbursementType.UNKNOWN : EnumUtils.findByName(DisbursementType.class, dType, DisbursementType.UNKNOWN);
    }

    public String getId() {
        return this.id;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public Calendar getDisbursementDate() {
        return this.disbursementDate;
    }

    public DisbursementType getDisbursementType() {
        return this.disbursementType;
    }

    public String getFollowUpAction() {
        return this.followUpAction;
    }

    public Boolean getRetry() {
        return this.retry;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public List<String> getTransactionIds() {
        return this.transactionIds;
    }

    public MerchantAccount getMerchantAccount() {
        return this.merchantAccount;
    }

    public ResourceCollection<Transaction> getTransactions(BraintreeGateway gateway) {
        TransactionSearchRequest searchRequest = new TransactionSearchRequest().ids().in(this.transactionIds);
        return gateway.transaction().search(searchRequest);
    }

    public static enum DisbursementType {
        UNKNOWN,
        CREDIT,
        DEBIT;

    }
}

