/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Adjustment;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Installment {
    private String id;
    private Calendar projectedDisbursementDate;
    private Calendar actualDisbursementDate;
    private BigDecimal amount;
    private List<Adjustment> adjustments;

    public Installment(NodeWrapper node) {
        this.id = node.findString("id");
        this.amount = node.findBigDecimal("amount");
        this.projectedDisbursementDate = node.findDateTime("projected_disbursement_date");
        this.actualDisbursementDate = node.findDateTime("actual_disbursement_date");
        this.adjustments = new ArrayList<Adjustment>();
        for (NodeWrapper adjustmentNode : node.findAll("adjustments/adjustment")) {
            this.adjustments.add(new Adjustment(adjustmentNode));
        }
    }

    public String getId() {
        return this.id;
    }

    public Calendar getProjectedDisbursementDate() {
        return this.projectedDisbursementDate;
    }

    public Calendar getActualDisbursementDate() {
        return this.actualDisbursementDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public List<Adjustment> getAdjustments() {
        return this.adjustments;
    }
}

