/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.MerchantAccount;
import com.braintreegateway.MerchantAccountCreateForCurrencyRequest;
import com.braintreegateway.MerchantAccountPager;
import com.braintreegateway.MerchantAccountRequest;
import com.braintreegateway.PaginatedCollection;
import com.braintreegateway.PaginatedResult;
import com.braintreegateway.Result;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;

public class MerchantAccountGateway {
    public static final String CREATE_URL = "/merchant_accounts/create_via_api";
    public static final String CREATE_FOR_CURRENCY_URL = "/merchant_accounts/create_for_currency";
    private final Http http;
    private Configuration configuration;

    public MerchantAccountGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<MerchantAccount> create(MerchantAccountRequest request) {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + CREATE_URL, request);
        return new Result<MerchantAccount>(response, MerchantAccount.class);
    }

    public Result<MerchantAccount> createForCurrency(MerchantAccountCreateForCurrencyRequest request) {
        NodeWrapper response = this.http.post(this.configuration.getMerchantPath() + CREATE_FOR_CURRENCY_URL, request);
        return new Result<MerchantAccount>(response, MerchantAccount.class);
    }

    public MerchantAccount find(String id) {
        if (id == null || id.trim().equals("")) {
            throw new NotFoundException();
        }
        return new MerchantAccount(this.http.get(this.configuration.getMerchantPath() + "/merchant_accounts/" + id));
    }

    public Result<MerchantAccount> update(String id, MerchantAccountRequest request) {
        NodeWrapper response = this.http.put(this.configuration.getMerchantPath() + "/merchant_accounts/" + id + "/update_via_api", request);
        return new Result<MerchantAccount>(response, MerchantAccount.class);
    }

    public PaginatedCollection<MerchantAccount> all() {
        return new PaginatedCollection<MerchantAccount>(new MerchantAccountPager(this));
    }

    public PaginatedResult<MerchantAccount> fetchMerchantAccounts(int page) {
        NodeWrapper response = this.http.get(this.configuration.getMerchantPath() + "/merchant_accounts?page=" + page);
        ArrayList<MerchantAccount> merchantAccounts = new ArrayList<MerchantAccount>();
        for (NodeWrapper node : response.findAll("merchant-account")) {
            merchantAccounts.add(new MerchantAccount(node));
        }
        return new PaginatedResult<MerchantAccount>(response.findInteger("total-items"), response.findInteger("page-size"), merchantAccounts);
    }
}

