/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Configuration;
import com.braintreegateway.OAuthConnectUrlRequest;
import com.braintreegateway.OAuthCredentials;
import com.braintreegateway.OAuthCredentialsRequest;
import com.braintreegateway.OAuthResult;
import com.braintreegateway.OAuthRevokeAccessTokenRequest;
import com.braintreegateway.Result;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;

public class OAuthGateway {
    private Http http;
    private Configuration configuration;

    public OAuthGateway(Http http, Configuration configuration) {
        this.http = http;
        this.configuration = configuration;
    }

    public Result<OAuthCredentials> createTokenFromCode(OAuthCredentialsRequest request) {
        request.grantType("authorization_code");
        NodeWrapper response = this.http.post("/oauth/access_tokens", request);
        return new Result<OAuthCredentials>(response, OAuthCredentials.class);
    }

    public Result<OAuthCredentials> createTokenFromRefreshToken(OAuthCredentialsRequest request) {
        request.grantType("refresh_token");
        NodeWrapper response = this.http.post("/oauth/access_tokens", request);
        return new Result<OAuthCredentials>(response, OAuthCredentials.class);
    }

    public Result<OAuthResult> revokeAccessToken(String accessToken) {
        OAuthRevokeAccessTokenRequest request = new OAuthRevokeAccessTokenRequest().token(accessToken);
        NodeWrapper response = this.http.post("/oauth/revoke_access_token", request);
        return new Result<OAuthResult>(response, OAuthResult.class);
    }

    public String connectUrl(OAuthConnectUrlRequest request) {
        request.clientId(this.configuration.getClientId());
        String queryString = request.toQueryString();
        return this.configuration.getBaseURL() + "/oauth/connect?" + queryString;
    }
}

