/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class PayPalAccount
implements PaymentMethod {
    private String billingAgreementId;
    private Calendar createdAt;
    private String customerId;
    private String email;
    private String fundingSourceDescription;
    private String imageUrl;
    private boolean isDefault;
    private String payerId;
    private Calendar revokedAt;
    private List<Subscription> subscriptions;
    private String token;
    private Calendar updatedAt;

    public PayPalAccount(NodeWrapper node) {
        this.billingAgreementId = node.findString("billing-agreement-id");
        this.createdAt = node.findDateTime("created-at");
        this.customerId = node.findString("customer-id");
        this.email = node.findString("email");
        this.fundingSourceDescription = node.findString("funding-source-description");
        this.imageUrl = node.findString("image-url");
        this.isDefault = node.findBoolean("default");
        this.payerId = node.findString("payer-id");
        this.revokedAt = node.findDateTime("revoked-at");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
        this.token = node.findString("token");
        this.updatedAt = node.findDateTime("updated-at");
    }

    public String getBillingAgreementId() {
        return this.billingAgreementId;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFundingSourceDescription() {
        return this.fundingSourceDescription;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getPayerId() {
        return this.payerId;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public Calendar getRevokedAt() {
        return this.revokedAt;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }
}

