/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class VenmoAccount
implements PaymentMethod {
    private String token;
    private String username;
    private String venmoUserId;
    private String sourceDescription;
    private String imageUrl;
    private Calendar createdAt;
    private Calendar updatedAt;
    private List<Subscription> subscriptions;
    private String customerId;
    private Boolean isDefault;

    public VenmoAccount(NodeWrapper node) {
        this.token = node.findString("token");
        this.username = node.findString("username");
        this.venmoUserId = node.findString("venmo-user-id");
        this.sourceDescription = node.findString("source-description");
        this.imageUrl = node.findString("image-url");
        this.createdAt = node.findDateTime("created-at");
        this.updatedAt = node.findDateTime("updated-at");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
        this.customerId = node.findString("customer-id");
        this.isDefault = node.findBoolean("default");
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public String getUsername() {
        return this.username;
    }

    public String getVenmoUserId() {
        return this.venmoUserId;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }
}

