/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Address;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class AndroidPayCard
implements PaymentMethod {
    private Address billingAddress;
    private String bin;
    private String cardType;
    private String commercial;
    private String countryOfIssuance;
    private Calendar createdAt;
    private String customerId;
    private String debit;
    private String durbinRegulated;
    private String expirationMonth;
    private String expirationYear;
    private String googleTransactionId;
    private String healthcare;
    private String imageUrl;
    private Boolean isDefault;
    private Boolean isNetworkTokenized;
    private String issuingBank;
    private String last4;
    private String payroll;
    private String prepaid;
    private String productId;
    private String sourceCardLast4;
    private String sourceCardType;
    private String sourceDescription;
    private List<Subscription> subscriptions;
    private String token;
    private Calendar updatedAt;
    private String virtualCardType;
    private String virtualCardLast4;

    public AndroidPayCard(NodeWrapper node) {
        this.bin = node.findString("bin");
        this.commercial = node.findString("commercial");
        this.countryOfIssuance = node.findString("country-of-issuance");
        this.createdAt = node.findDateTime("created-at");
        this.customerId = node.findString("customer-id");
        this.debit = node.findString("debit");
        this.durbinRegulated = node.findString("durbin-regulated");
        this.expirationMonth = node.findString("expiration-month");
        this.expirationYear = node.findString("expiration-year");
        this.googleTransactionId = node.findString("google-transaction-id");
        this.healthcare = node.findString("healthcare");
        this.imageUrl = node.findString("image-url");
        this.isDefault = node.findBoolean("default");
        this.isNetworkTokenized = node.findBoolean("is-network-tokenized");
        this.issuingBank = node.findString("issuing-bank");
        this.payroll = node.findString("payroll");
        this.prepaid = node.findString("prepaid");
        this.productId = node.findString("product-id");
        this.sourceCardType = node.findString("source-card-type");
        this.sourceDescription = node.findString("source-description");
        this.sourceCardLast4 = node.findString("source-card-last-4");
        this.token = node.findString("token");
        this.updatedAt = node.findDateTime("updated-at");
        this.virtualCardLast4 = node.findString("virtual-card-last-4");
        this.virtualCardType = node.findString("virtual-card-type");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
        NodeWrapper billingAddressResponse = node.findFirst("billing-address");
        if (billingAddressResponse != null) {
            this.billingAddress = new Address(billingAddressResponse);
        }
        this.cardType = this.virtualCardType;
        this.last4 = this.virtualCardLast4;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public String getBin() {
        return this.bin;
    }

    public String getCardType() {
        return this.cardType;
    }

    public String getCommercial() {
        return this.commercial;
    }

    public String getCountryOfIssuance() {
        return this.countryOfIssuance;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public String getDebit() {
        return this.debit;
    }

    public String getDurbinRegulated() {
        return this.durbinRegulated;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    public String getGoogleTransactionId() {
        return this.googleTransactionId;
    }

    public String getHealthcare() {
        return this.healthcare;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getIssuingBank() {
        return this.issuingBank;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getPayroll() {
        return this.payroll;
    }

    public String getPrepaid() {
        return this.prepaid;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getSourceCardLast4() {
        return this.sourceCardLast4;
    }

    public String getSourceCardType() {
        return this.sourceCardType;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public String getVirtualCardLast4() {
        return this.virtualCardLast4;
    }

    public String getVirtualCardType() {
        return this.virtualCardType;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isNetworkTokenized() {
        return this.isNetworkTokenized;
    }
}

