/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AchMandate;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.UsBankAccountVerification;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class UsBankAccount
implements PaymentMethod {
    private String accountHolderName;
    private String accountType;
    private AchMandate achMandate;
    private String bankName;
    private String businessName;
    private Calendar createdAt;
    private String customerId;
    private String description;
    private String firstName;
    private String imageUrl;
    private String last4;
    private String lastName;
    private String ownerId;
    private String ownershipType;
    private Calendar plaidVerifiedAt;
    private String routingNumber;
    private List<Subscription> subscriptions;
    private String token;
    private Calendar updatedAt;
    private List<UsBankAccountVerification> verifications;
    private Boolean isDefault;
    private boolean isVerifiable;
    private Boolean isVerified;

    public UsBankAccount(NodeWrapper node) {
        this.accountHolderName = node.findString("account-holder-name");
        this.accountType = node.findString("account-type");
        NodeWrapper achMandateNode = node.findFirst("ach-mandate");
        if (achMandateNode != null) {
            this.achMandate = new AchMandate(achMandateNode);
        }
        this.bankName = node.findString("bank-name");
        this.businessName = node.findString("business-name");
        this.createdAt = node.findDateTime("created-at");
        this.customerId = node.findString("customer-id");
        this.description = node.findString("description");
        this.firstName = node.findString("first-name");
        this.imageUrl = node.findString("image-url");
        this.last4 = node.findString("last-4");
        this.lastName = node.findString("last-name");
        this.ownerId = node.findString("owner-id");
        this.ownershipType = node.findString("ownership-type");
        this.plaidVerifiedAt = node.findDateTime("plaid-verified-at");
        this.routingNumber = node.findString("routing-number");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
        this.token = node.findString("token");
        this.updatedAt = node.findDateTime("updated-at");
        this.verifications = new ArrayList<UsBankAccountVerification>();
        for (NodeWrapper verification : node.findAll("verifications/us-bank-account-verification")) {
            this.verifications.add(new UsBankAccountVerification(verification));
        }
        this.isDefault = node.findBoolean("default");
        this.isVerifiable = node.findBoolean("verifiable");
        this.isVerified = node.findBoolean("verified");
    }

    public String getAccountHolderName() {
        return this.accountHolderName;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public AchMandate getAchMandate() {
        return this.achMandate;
    }

    public String getBankName() {
        return this.bankName;
    }

    public String getBusinessName() {
        return this.businessName;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getOwnershipType() {
        return this.ownershipType;
    }

    public Calendar getPlaidVerifiedAt() {
        return this.plaidVerifiedAt;
    }

    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public List<UsBankAccountVerification> getVerifications() {
        return this.verifications;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isVerifiable() {
        return this.isVerifiable;
    }

    public Boolean isVerified() {
        return this.isVerified;
    }
}

