/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;

public class SepaDirectDebitAccountDetails {
    private MandateType mandateType;
    private SettlementType settlementType;
    private String bankReferenceToken;
    private String captureId;
    private String merchantOrPartnerCustomerId;
    private String debugId;
    private String last4;
    private String paypalV2OrderId;
    private String refundFromTransactionFeeAmount;
    private String refundFromTransactionFeeCurrencyIsoCode;
    private String refundId;
    private String token;
    private String transactionFeeAmount;
    private String transactionFeeCurrencyIsoCode;

    public SepaDirectDebitAccountDetails(NodeWrapper node) {
        this.bankReferenceToken = node.findString("bank-reference-token");
        this.captureId = node.findString("capture-id");
        this.debugId = node.findString("debug-id");
        this.last4 = node.findString("last-4");
        this.mandateType = EnumUtils.findByName(MandateType.class, node.findString("mandate-type"), MandateType.ONE_OFF);
        this.merchantOrPartnerCustomerId = node.findString("merchant-or-partner-customer-id");
        this.paypalV2OrderId = node.findString("paypal-v2-order-id");
        this.refundFromTransactionFeeAmount = node.findString("refund-from-transaction-fee-amount");
        this.refundFromTransactionFeeCurrencyIsoCode = node.findString("refund-from-transaction-fee-currency-iso-code");
        this.refundId = node.findString("refund-id");
        this.settlementType = EnumUtils.findByName(SettlementType.class, node.findString("settlement-type"), SettlementType.INSTANT);
        this.token = node.findString("token");
        this.transactionFeeAmount = node.findString("transaction-fee-amount");
        this.transactionFeeCurrencyIsoCode = node.findString("transaction-fee-currency-iso-code");
    }

    public String getPayPalV2OrderId() {
        return this.paypalV2OrderId;
    }

    public MandateType getMandateType() {
        return this.mandateType;
    }

    public String getBankReferenceToken() {
        return this.bankReferenceToken;
    }

    public String getMerchantOrPartnerCustomerId() {
        return this.merchantOrPartnerCustomerId;
    }

    public String getLast4() {
        return this.last4;
    }

    public String getDebugId() {
        return this.debugId;
    }

    public String getRefundId() {
        return this.refundId;
    }

    public String getCaptureId() {
        return this.captureId;
    }

    public String getTransactionFeeAmount() {
        return this.transactionFeeAmount;
    }

    public String getTransactionFeeCurrencyIsoCode() {
        return this.transactionFeeCurrencyIsoCode;
    }

    public String getRefundFromTransactionFeeAmount() {
        return this.refundFromTransactionFeeAmount;
    }

    public String getRefundFromTransactionFeeCurrencyIsoCode() {
        return this.refundFromTransactionFeeCurrencyIsoCode;
    }

    public SettlementType getSettlementType() {
        return this.settlementType;
    }

    public String getToken() {
        return this.token;
    }

    public static enum SettlementType {
        INSTANT("INSTANT"),
        DELAYED("DELAYED");

        private final String name;

        private SettlementType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum MandateType {
        ONE_OFF("ONE_OFF"),
        RECURRENT("RECURRENT");

        private final String name;

        private MandateType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

