/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.json.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FilePatternMatcher;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.json.api.model.JSONFileDescriptor;
import com.buschmais.jqassistant.plugin.json.impl.parsing.IsNPECausedByANTLRIssue746Predicate;
import com.buschmais.jqassistant.plugin.json.impl.parsing.JQAssistantJSONLexer;
import com.buschmais.jqassistant.plugin.json.impl.parsing.JQAssistantJSONParser;
import com.buschmais.jqassistant.plugin.json.impl.parsing.JSONTreeWalker;
import com.buschmais.jqassistant.plugin.json.impl.parsing.generated.JSONParser;
import java.io.IOException;
import java.io.InputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class JSONFileScannerPlugin
extends AbstractScannerPlugin<FileResource, JSONFileDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSONFileScannerPlugin.class);
    public static final String PROPERTY_INCLUDE = "json.file.include";
    public static final String PROPERTY_EXCLUDE = "json.file.exclude";
    private FilePatternMatcher filePatternMatcher;
    public static final String JSON_FILE_EXTENSION = ".json";
    private IsNPECausedByANTLRIssue746Predicate antlrPredicate = new IsNPECausedByANTLRIssue746Predicate();

    protected FilePatternMatcher getFilePatternMatcher() {
        return this.filePatternMatcher;
    }

    protected boolean isFilePatternMatcherActive() {
        return null != this.getFilePatternMatcher();
    }

    protected void configure() {
        String inclusionPattern = this.getStringProperty(PROPERTY_INCLUDE, null);
        String exclusionPattern = this.getStringProperty(PROPERTY_EXCLUDE, null);
        if (null != inclusionPattern || null != exclusionPattern) {
            this.filePatternMatcher = FilePatternMatcher.builder().include(inclusionPattern).exclude(exclusionPattern).build();
        }
    }

    public boolean accepts(FileResource file, String path, Scope scope) throws IOException {
        boolean decision = true;
        decision = this.isFilePatternMatcherActive() ? this.getFilePatternMatcher().accepts(path) : path.toLowerCase().endsWith(JSON_FILE_EXTENSION);
        return decision;
    }

    public JSONFileDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        JSONFileDescriptor jsonFileDescriptor;
        block3: {
            ScannerContext context = scanner.getContext();
            Store store = context.getStore();
            FileDescriptor fileDescriptor = (FileDescriptor)context.getCurrentDescriptor();
            jsonFileDescriptor = (JSONFileDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, JSONFileDescriptor.class);
            jsonFileDescriptor.setValid(false);
            try {
                JQAssistantJSONLexer lexer = new JQAssistantJSONLexer(CharStreams.fromStream((InputStream)item.createStream()), path);
                JQAssistantJSONParser parser = new JQAssistantJSONParser((TokenStream)new CommonTokenStream((TokenSource)lexer), path);
                JSONParser.DocumentContext jsonDocumentContext = parser.document();
                ParseTreeWalker walker = new ParseTreeWalker();
                walker.walk((ParseTreeListener)new JSONTreeWalker(jsonFileDescriptor, scanner), (ParseTree)jsonDocumentContext);
                jsonFileDescriptor.setValid(true);
            }
            catch (RecoverableParsingException | IllegalStateException | RecognitionException e) {
                LOGGER.warn("JSON file '{}' seems to be invalid and will be marked as invalid. Result graph might be incorrect: {}", (Object)path, (Object)e);
            }
            catch (NullPointerException e) {
                boolean isCausedByANTLR = this.antlrPredicate.isNPECausedByANTLRIssue746Predicate(e);
                if (isCausedByANTLR) break block3;
                throw e;
            }
        }
        return jsonFileDescriptor;
    }

    public static class RecoverableParsingException
    extends RuntimeException {
        RecoverableParsingException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class MyErrorListener
    extends BaseErrorListener {
        private final String absolutePath;

        public MyErrorListener(String absolutePath) {
            this.absolutePath = absolutePath;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            Object toPropagate = e;
            LOGGER.warn("Failed to parse '{}' at {}:{}, due to '{}'.", new Object[]{this.absolutePath, line, charPositionInLine, msg});
            if (null == toPropagate) {
                toPropagate = new RecoverableParsingException(msg);
            }
            throw toPropagate;
        }
    }
}

