/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.api.model;

import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomXmlDescriptor;
import com.buschmais.xo.api.annotation.ResultOf;
import com.buschmais.xo.neo4j.api.annotation.Cypher;
import com.buschmais.xo.neo4j.api.annotation.Indexed;
import com.buschmais.xo.neo4j.api.annotation.Label;
import com.buschmais.xo.neo4j.api.annotation.Property;
import com.buschmais.xo.neo4j.api.annotation.Relation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;

@Label(value="Repository")
public interface MavenRepositoryDescriptor
extends MavenDescriptor {
    @Relation(value="CONTAINS_POM")
    public List<MavenPomXmlDescriptor> getContainedModels();

    @Relation(value="CONTAINS_ARTIFACT")
    public List<MavenArtifactDescriptor> getContainedArtifacts();

    @Indexed
    public String getUrl();

    public void setUrl(String var1);

    @Property(value="lastUpdate")
    public long getLastUpdate();

    public void setLastUpdate(long var1);

    public void setId(String var1);

    public String getId();

    public void setLayout(String var1);

    public String getLayout();

    public void setName(String var1);

    public String getName();

    public void setReleasesEnabled(boolean var1);

    public boolean getReleasesEnabled();

    public void setReleasesUpdatePolicy(String var1);

    public String getReleasesUpdatePolicy();

    public void setReleasesChecksumPolicy(String var1);

    public String getReleasesChecksumPolicy();

    public void setSnapshotsEnabled(boolean var1);

    public boolean getSnapshotsEnabled();

    public void setSnapshotsUpdatePolicy(String var1);

    public String getSnapshotsUpdatePolicy();

    public void setSnapshotsChecksumPolicy(String var1);

    public String getSnapshotsChecksumPolicy();

    @ResultOf
    @Cypher(value="MATCH (repository)-[:CONTAINS_POM]->(pom:Maven:Pom:Release:Xml) WHERE id(repository)=$this and pom.fqn=$coordinates RETURN pom")
    public MavenPomXmlDescriptor findReleaseModel(@ResultOf.Parameter(value="coordinates") String var1);

    @ResultOf
    @Cypher(value="MATCH (repository)-[:CONTAINS_POM]->(pom:Maven:Pom:Snapshot:Xml) WHERE id(repository)=$this and pom.fqn=$coordinates RETURN pom")
    public MavenPomXmlDescriptor findSnapshotModel(@ResultOf.Parameter(value="coordinates") String var1);

    @ResultOf
    @Cypher(value="MATCH (repository), (pom:Maven:Pom:Xml) WHERE id(repository)=$this and id(pom)=$pom CREATE (repository)-[:CONTAINS_POM]->(pom)")
    public void addModel(@ResultOf.Parameter(value="pom") MavenPomXmlDescriptor var1);

    @ResultOf
    @Cypher(value="MATCH (repository)-[:CONTAINS_ARTIFACT]->(artifact:Artifact) WHERE id(repository)=$this and artifact.fqn=$coordinates RETURN artifact")
    public MavenArtifactDescriptor findArtifact(@ResultOf.Parameter(value="coordinates") String var1);

    @ResultOf
    @Cypher(value="MATCH (repository), (artifact:Maven:Artifact) WHERE id(repository)=$this and id(artifact)=$artifact CREATE (repository)-[:CONTAINS_ARTIFACT]->(artifact)")
    public void addArtifact(@ResultOf.Parameter(value="artifact") MavenArtifactDescriptor var1);

    @Relation(value="CONTAINS_GROUP_ID")
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface ContainsGroupId {
    }
}

