/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArrayValueDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.PropertyDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ValueDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.DependencyCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ModelCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ParentCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.PluginCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.model.BaseProfileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.ConfigurableDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.EffectiveDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenActivationFileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenActivationOSDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenConfigurationDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenContributorDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenDependencyDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenDependentDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenDeveloperDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenExcludesDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenExecutionGoalDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenLicenseDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenModuleDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenOrganizationDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenParticipantRoleDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPluginDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPluginExecutionDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProfileActivationDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProfileDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectParticipantDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenRepositoryDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenScmDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.EffectiveModel;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenRepositoryResolver;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact.MavenArtifactResolver;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Contributor;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Developer;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.License;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Organization;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryPolicy;
import org.apache.maven.model.Scm;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class MavenModelScannerPlugin
extends AbstractScannerPlugin<Model, MavenPomDescriptor> {
    protected void configure() {
        this.getScannerContext().push(ArtifactResolver.class, (Object)new MavenArtifactResolver());
    }

    public Class<? extends Model> getType() {
        return Model.class;
    }

    public Class<MavenPomDescriptor> getDescriptorType() {
        return MavenPomDescriptor.class;
    }

    public boolean accepts(Model item, String path, Scope scope) {
        return true;
    }

    public MavenPomDescriptor scan(Model model, String path, Scope scope, Scanner scanner) {
        MavenPomDescriptor pomDescriptor = this.createMavenPomDescriptor(model, scanner);
        ScannerContext scannerContext = scanner.getContext();
        Store store = scannerContext.getStore();
        this.addParent(pomDescriptor, model, scannerContext);
        this.addProfiles(pomDescriptor, model, scannerContext);
        this.addProperties(pomDescriptor, model.getProperties(), store);
        this.addModules(pomDescriptor, model.getModules(), store);
        this.addDependencies(pomDescriptor, (ModelBase)model, scannerContext);
        this.addManagedPlugins(pomDescriptor, (BuildBase)model.getBuild(), scannerContext);
        this.addPlugins(pomDescriptor, (BuildBase)model.getBuild(), scannerContext);
        this.addLicenses(pomDescriptor, model, store);
        this.addDevelopers(pomDescriptor, model, store);
        this.addContributors(pomDescriptor, model, store);
        this.addOrganization(pomDescriptor, model, store);
        this.addRepository(MavenModelScannerPlugin.of(pomDescriptor), model.getRepositories(), store);
        this.addScmInformation(pomDescriptor, model.getScm(), store);
        return pomDescriptor;
    }

    private void addScmInformation(MavenPomDescriptor pomDescriptor, Scm scmInformation, Store store) {
        Optional.ofNullable(scmInformation).ifPresent(scm -> {
            MavenScmDescriptor scmDescriptor = (MavenScmDescriptor)store.create(MavenScmDescriptor.class);
            Optional.ofNullable(scm.getConnection()).ifPresent(scmDescriptor::setConnection);
            Optional.ofNullable(scm.getDeveloperConnection()).ifPresent(scmDescriptor::setDeveloperConnection);
            Optional.ofNullable(scm.getTag()).ifPresent(scmDescriptor::setTag);
            Optional.ofNullable(scm.getUrl()).ifPresent(scmDescriptor::setUrl);
            pomDescriptor.setScm(scmDescriptor);
        });
    }

    private void addOrganization(MavenPomDescriptor pomDescriptor, Model model, Store store) {
        Organization mavenOrganization = model.getOrganization();
        if (null != mavenOrganization) {
            MavenOrganizationDescriptor organization = (MavenOrganizationDescriptor)store.create(MavenOrganizationDescriptor.class);
            organization.setName(mavenOrganization.getName());
            organization.setUrl(mavenOrganization.getUrl());
            pomDescriptor.setOrganization(organization);
        }
    }

    private void addContributors(MavenPomDescriptor pomDescriptor, Model model, Store store) {
        List contributors = model.getContributors();
        for (Contributor contributor : contributors) {
            MavenContributorDescriptor contributorDescriptor = (MavenContributorDescriptor)store.create(MavenContributorDescriptor.class);
            this.addCommonParticipantAttributes(contributorDescriptor, contributor, store);
            pomDescriptor.getContributors().add(contributorDescriptor);
        }
    }

    private void addCommonParticipantAttributes(MavenProjectParticipantDescriptor participant, Contributor contributor, Store store) {
        participant.setName(contributor.getName());
        participant.setEmail(contributor.getEmail());
        participant.setUrl(contributor.getUrl());
        participant.setOrganization(contributor.getOrganization());
        participant.setOrganizationUrl(contributor.getOrganizationUrl());
        participant.setTimezone(contributor.getTimezone());
        if (contributor.getRoles() != null) {
            for (String role : contributor.getRoles()) {
                MavenParticipantRoleDescriptor developerRoleDescriptor = (MavenParticipantRoleDescriptor)store.create(MavenParticipantRoleDescriptor.class);
                developerRoleDescriptor.setName(role);
                participant.getRoles().add(developerRoleDescriptor);
            }
        }
    }

    protected MavenPomDescriptor createMavenPomDescriptor(Model model, Scanner scanner) {
        ScannerContext context = scanner.getContext();
        MavenPomDescriptor pomDescriptor = (MavenPomDescriptor)context.peek(MavenPomDescriptor.class);
        pomDescriptor.setName(model.getName());
        pomDescriptor.setGroupId(model.getGroupId());
        pomDescriptor.setArtifactId(model.getArtifactId());
        pomDescriptor.setPackaging(model.getPackaging());
        pomDescriptor.setVersion(model.getVersion());
        pomDescriptor.setUrl(model.getUrl());
        pomDescriptor.setDescription(model.getDescription());
        ModelCoordinates artifactCoordinates = new ModelCoordinates(model);
        MavenArtifactDescriptor artifact = ((ArtifactResolver)context.peek(ArtifactResolver.class)).resolve(artifactCoordinates, context);
        pomDescriptor.getDescribes().add(artifact);
        if (model instanceof EffectiveModel) {
            return (MavenPomDescriptor)context.getStore().addDescriptorType((Descriptor)pomDescriptor, EffectiveDescriptor.class, MavenPomDescriptor.class);
        }
        return pomDescriptor;
    }

    private void addActivation(MavenProfileDescriptor mavenProfileDescriptor, Activation activation, Store store) {
        ActivationProperty property;
        ActivationOS os;
        if (null == activation) {
            return;
        }
        MavenProfileActivationDescriptor profileActivationDescriptor = (MavenProfileActivationDescriptor)store.create(MavenProfileActivationDescriptor.class);
        mavenProfileDescriptor.setActivation(profileActivationDescriptor);
        profileActivationDescriptor.setJdk(activation.getJdk());
        profileActivationDescriptor.setActiveByDefault(activation.isActiveByDefault());
        ActivationFile activationFile = activation.getFile();
        if (null != activationFile) {
            MavenActivationFileDescriptor activationFileDescriptor = (MavenActivationFileDescriptor)store.create(MavenActivationFileDescriptor.class);
            profileActivationDescriptor.setActivationFile(activationFileDescriptor);
            activationFileDescriptor.setExists(activationFile.getExists());
            activationFileDescriptor.setMissing(activationFile.getMissing());
        }
        if (null != (os = activation.getOs())) {
            MavenActivationOSDescriptor osDescriptor = (MavenActivationOSDescriptor)store.create(MavenActivationOSDescriptor.class);
            profileActivationDescriptor.setActivationOS(osDescriptor);
            osDescriptor.setArch(os.getArch());
            osDescriptor.setFamily(os.getFamily());
            osDescriptor.setName(os.getName());
            osDescriptor.setVersion(os.getVersion());
        }
        if (null != (property = activation.getProperty())) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            profileActivationDescriptor.setProperty(propertyDescriptor);
            propertyDescriptor.setName(property.getName());
            propertyDescriptor.setValue(property.getValue());
        }
    }

    private void addConfiguration(ConfigurableDescriptor configurableDescriptor, Xpp3Dom config, Store store) {
        Xpp3Dom[] children;
        if (null == config) {
            return;
        }
        MavenConfigurationDescriptor configDescriptor = (MavenConfigurationDescriptor)store.create(MavenConfigurationDescriptor.class);
        configurableDescriptor.setConfiguration(configDescriptor);
        for (Xpp3Dom child : children = config.getChildren()) {
            configDescriptor.getValues().add(this.getConfigChildNodes(child, store));
        }
    }

    private void addDependencies(MavenDependentDescriptor dependentDescriptor, ModelBase model, ScannerContext scannerContext) {
        dependentDescriptor.getDeclaresDependencies().addAll(this.getDependencies(model.getDependencies(), scannerContext));
        dependentDescriptor.getManagesDependencies().addAll(this.addManagedDependencies(model.getDependencyManagement(), scannerContext));
    }

    private List<MavenDependencyDescriptor> getDependencies(List<Dependency> dependencies, ScannerContext scannerContext) {
        Store store = scannerContext.getStore();
        ArrayList<MavenDependencyDescriptor> dependencyDescriptors = new ArrayList<MavenDependencyDescriptor>(dependencies.size());
        Map<Dependency, MavenArtifactDescriptor> mavenArtifactDescriptors = dependencies.stream().collect(Collectors.toMap(dependency -> dependency, dependency -> this.getMavenArtifactDescriptor((Dependency)dependency, scannerContext)));
        for (Dependency dependency2 : dependencies) {
            MavenArtifactDescriptor dependencyArtifactDescriptor = mavenArtifactDescriptors.get(dependency2);
            MavenDependencyDescriptor dependencyDescriptor = (MavenDependencyDescriptor)store.create(MavenDependencyDescriptor.class);
            dependencyDescriptor.setToArtifact(dependencyArtifactDescriptor);
            dependencyDescriptor.setOptional(dependency2.isOptional());
            dependencyDescriptor.setScope(dependency2.getScope());
            for (Exclusion exclusion : dependency2.getExclusions()) {
                MavenExcludesDescriptor mavenExcludesDescriptor = (MavenExcludesDescriptor)store.create(MavenExcludesDescriptor.class);
                mavenExcludesDescriptor.setGroupId(exclusion.getGroupId());
                mavenExcludesDescriptor.setArtifactId(exclusion.getArtifactId());
                dependencyDescriptor.getExclusions().add(mavenExcludesDescriptor);
            }
            dependencyDescriptors.add(dependencyDescriptor);
        }
        return dependencyDescriptors;
    }

    private void addExecutionGoals(MavenPluginExecutionDescriptor executionDescriptor, PluginExecution pluginExecution, Store store) {
        List goals = pluginExecution.getGoals();
        for (String goal : goals) {
            MavenExecutionGoalDescriptor goalDescriptor = (MavenExecutionGoalDescriptor)store.create(MavenExecutionGoalDescriptor.class);
            goalDescriptor.setName(goal);
            executionDescriptor.getGoals().add(goalDescriptor);
        }
    }

    private void addLicenses(MavenPomDescriptor pomDescriptor, Model model, Store store) {
        List licenses = model.getLicenses();
        for (License license : licenses) {
            MavenLicenseDescriptor licenseDescriptor = (MavenLicenseDescriptor)store.create(MavenLicenseDescriptor.class);
            licenseDescriptor.setUrl(license.getUrl());
            licenseDescriptor.setComments(license.getComments());
            licenseDescriptor.setName(license.getName());
            licenseDescriptor.setDistribution(license.getDistribution());
            pomDescriptor.getLicenses().add(licenseDescriptor);
        }
    }

    private void addDevelopers(MavenPomDescriptor pomDescriptor, Model model, Store store) {
        List developers = model.getDevelopers();
        for (Developer developer : developers) {
            MavenDeveloperDescriptor developerDescriptor = (MavenDeveloperDescriptor)store.create(MavenDeveloperDescriptor.class);
            developerDescriptor.setId(developer.getId());
            this.addCommonParticipantAttributes(developerDescriptor, (Contributor)developer, store);
            pomDescriptor.getDevelopers().add(developerDescriptor);
        }
    }

    private List<MavenDependencyDescriptor> addManagedDependencies(DependencyManagement dependencyManagement, ScannerContext scannerContext) {
        if (dependencyManagement == null) {
            return Collections.emptyList();
        }
        List dependencies = dependencyManagement.getDependencies();
        return this.getDependencies(dependencies, scannerContext);
    }

    private void addManagedPlugins(BaseProfileDescriptor pomDescriptor, BuildBase build, ScannerContext scannerContext) {
        if (null == build) {
            return;
        }
        PluginManagement pluginManagement = build.getPluginManagement();
        if (null == pluginManagement) {
            return;
        }
        List<MavenPluginDescriptor> pluginDescriptors = this.createMavenPluginDescriptors(pluginManagement.getPlugins(), scannerContext);
        pomDescriptor.getManagedPlugins().addAll(pluginDescriptors);
    }

    private List<MavenPluginDescriptor> createMavenPluginDescriptors(List<Plugin> plugins, ScannerContext context) {
        Store store = context.getStore();
        ArrayList<MavenPluginDescriptor> pluginDescriptors = new ArrayList<MavenPluginDescriptor>();
        for (Plugin plugin : plugins) {
            MavenPluginDescriptor mavenPluginDescriptor = (MavenPluginDescriptor)store.create(MavenPluginDescriptor.class);
            MavenArtifactDescriptor artifactDescriptor = ((ArtifactResolver)context.peek(ArtifactResolver.class)).resolve(new PluginCoordinates(plugin), context);
            mavenPluginDescriptor.setArtifact(artifactDescriptor);
            mavenPluginDescriptor.setInherited(plugin.isInherited());
            mavenPluginDescriptor.getDeclaresDependencies().addAll(this.getDependencies(plugin.getDependencies(), context));
            this.addPluginExecutions(mavenPluginDescriptor, plugin, store);
            this.addConfiguration(mavenPluginDescriptor, (Xpp3Dom)plugin.getConfiguration(), store);
            pluginDescriptors.add(mavenPluginDescriptor);
        }
        return pluginDescriptors;
    }

    private void addModules(BaseProfileDescriptor pomDescriptor, List<String> modules, Store store) {
        for (String module : modules) {
            MavenModuleDescriptor moduleDescriptor = (MavenModuleDescriptor)store.create(MavenModuleDescriptor.class);
            moduleDescriptor.setName(module);
            pomDescriptor.getModules().add(moduleDescriptor);
        }
    }

    private void addParent(MavenPomDescriptor pomDescriptor, Model model, ScannerContext context) {
        Parent parent = model.getParent();
        if (null != parent) {
            ArtifactResolver resolver = (ArtifactResolver)context.peek(ArtifactResolver.class);
            MavenArtifactDescriptor parentDescriptor = resolver.resolve(new ParentCoordinates(parent), context);
            pomDescriptor.setParent(parentDescriptor);
        }
    }

    private void addPluginExecutions(MavenPluginDescriptor mavenPluginDescriptor, Plugin plugin, Store store) {
        List executions = plugin.getExecutions();
        for (PluginExecution pluginExecution : executions) {
            MavenPluginExecutionDescriptor executionDescriptor = (MavenPluginExecutionDescriptor)store.create(MavenPluginExecutionDescriptor.class);
            executionDescriptor.setId(pluginExecution.getId());
            executionDescriptor.setPhase(pluginExecution.getPhase());
            executionDescriptor.setInherited(pluginExecution.isInherited());
            mavenPluginDescriptor.getExecutions().add(executionDescriptor);
            this.addExecutionGoals(executionDescriptor, pluginExecution, store);
            this.addConfiguration(executionDescriptor, (Xpp3Dom)pluginExecution.getConfiguration(), store);
        }
    }

    private void addPlugins(BaseProfileDescriptor pomDescriptor, BuildBase build, ScannerContext scannerContext) {
        if (null == build) {
            return;
        }
        List plugins = build.getPlugins();
        List<MavenPluginDescriptor> pluginDescriptors = this.createMavenPluginDescriptors(plugins, scannerContext);
        pomDescriptor.getPlugins().addAll(pluginDescriptors);
    }

    private void addProfiles(MavenPomDescriptor pomDescriptor, Model model, ScannerContext scannerContext) {
        List profiles = model.getProfiles();
        Store store = scannerContext.getStore();
        for (Profile profile : profiles) {
            MavenProfileDescriptor mavenProfileDescriptor = (MavenProfileDescriptor)store.create(MavenProfileDescriptor.class);
            pomDescriptor.getProfiles().add(mavenProfileDescriptor);
            mavenProfileDescriptor.setId(profile.getId());
            this.addProperties(mavenProfileDescriptor, profile.getProperties(), store);
            this.addModules(mavenProfileDescriptor, profile.getModules(), store);
            this.addPlugins(mavenProfileDescriptor, profile.getBuild(), scannerContext);
            this.addManagedPlugins(mavenProfileDescriptor, profile.getBuild(), scannerContext);
            this.addDependencies(mavenProfileDescriptor, (ModelBase)profile, scannerContext);
            this.addActivation(mavenProfileDescriptor, profile.getActivation(), store);
            this.addRepository(MavenModelScannerPlugin.of(mavenProfileDescriptor), profile.getRepositories(), store);
        }
    }

    private void addRepository(RepositoryHolder holder, List<Repository> repositories, Store store) {
        for (Repository repo : repositories) {
            MavenRepositoryDescriptor repoDescriptor = MavenRepositoryResolver.resolve(store, repo.getUrl());
            repoDescriptor.setName(repo.getName());
            repoDescriptor.setId(repo.getId());
            repoDescriptor.setLayout(repo.getLayout() != null ? repo.getLayout() : "default");
            WrappedPolicy relPolicy = new WrappedPolicy(repo.getReleases());
            WrappedPolicy snapPolicy = new WrappedPolicy(repo.getSnapshots());
            repoDescriptor.setReleasesChecksumPolicy(relPolicy.getChecksumPolicy());
            repoDescriptor.setReleasesUpdatePolicy(relPolicy.getUpdatePolicy());
            repoDescriptor.setReleasesEnabled(relPolicy.isEnabled());
            repoDescriptor.setSnapshotsChecksumPolicy(snapPolicy.getChecksumPolicy());
            repoDescriptor.setSnapshotsUpdatePolicy(snapPolicy.getUpdatePolicy());
            repoDescriptor.setSnapshotsEnabled(snapPolicy.isEnabled());
            holder.getRepositories().add(repoDescriptor);
        }
    }

    private void addProperties(BaseProfileDescriptor pomDescriptor, Properties properties, Store store) {
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            propertyDescriptor.setName(entry.getKey().toString());
            propertyDescriptor.setValue(entry.getValue().toString());
            pomDescriptor.getProperties().add(propertyDescriptor);
        }
    }

    private MavenArtifactDescriptor getMavenArtifactDescriptor(Dependency dependency, ScannerContext context) {
        DependencyCoordinates coordinates = new DependencyCoordinates(dependency);
        return ((ArtifactResolver)context.peek(ArtifactResolver.class)).resolve(coordinates, context);
    }

    private ValueDescriptor<?> getConfigChildNodes(Xpp3Dom node, Store store) {
        Xpp3Dom[] children = node.getChildren();
        if (children.length == 0) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)store.create(PropertyDescriptor.class);
            propertyDescriptor.setName(node.getName());
            propertyDescriptor.setValue(node.getValue());
            return propertyDescriptor;
        }
        ArrayValueDescriptor childDescriptor = (ArrayValueDescriptor)store.create(ArrayValueDescriptor.class);
        childDescriptor.setName(node.getName());
        for (Xpp3Dom child : children) {
            childDescriptor.getValue().add(this.getConfigChildNodes(child, store));
        }
        return childDescriptor;
    }

    private static RepositoryHolder of(final MavenProfileDescriptor profileDescriptor) {
        return new RepositoryHolder(){

            @Override
            public List<MavenRepositoryDescriptor> getRepositories() {
                return profileDescriptor.getRepositories();
            }
        };
    }

    private static RepositoryHolder of(final MavenPomDescriptor pomDescriptor) {
        return new RepositoryHolder(){

            @Override
            public List<MavenRepositoryDescriptor> getRepositories() {
                return pomDescriptor.getRepositories();
            }
        };
    }

    protected static interface RepositoryHolder {
        public List<MavenRepositoryDescriptor> getRepositories();
    }

    static class WrappedPolicy {
        RepositoryPolicy original;

        private WrappedPolicy(RepositoryPolicy policy) {
            this.original = policy;
        }

        public String getChecksumPolicy() {
            if (this.original != null) {
                return (String)MoreObjects.firstNonNull((Object)this.original.getChecksumPolicy(), (Object)"warn");
            }
            return "warn";
        }

        public String getUpdatePolicy() {
            if (this.original != null) {
                return (String)MoreObjects.firstNonNull((Object)this.original.getUpdatePolicy(), (Object)"daily");
            }
            return "daily";
        }

        public boolean isEnabled() {
            boolean result = true;
            if (this.original != null) {
                result = (Boolean)MoreObjects.firstNonNull((Object)this.original.isEnabled(), (Object)true);
            }
            return result;
        }
    }
}

