/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing;

import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.AbstractBaseNode;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.ParsingContextType;
import com.buschmais.jqassistant.plugin.yaml2.impl.scanner.parsing.StreamNode;
import java.util.Deque;
import java.util.LinkedList;

public class ParserContext {
    private LinkedList<ParsingContextType<? extends AbstractBaseNode>> stack = new LinkedList();
    private StreamNode rootNode;

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public <N extends AbstractBaseNode> void enter(ParsingContextType<N> type) {
        this.getStack().push(type);
    }

    private Deque<ParsingContextType<? extends AbstractBaseNode>> getStack() {
        return this.stack;
    }

    public ParsingContextType<? extends AbstractBaseNode> peek() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No context available at the moment");
        }
        return this.getStack().peek();
    }

    public void leave() {
        if (this.isEmpty()) {
            throw new IllegalStateException("No context available at the moment");
        }
        this.getStack().pop();
    }

    boolean isInDocument() {
        return this.peek().getType() == ParsingContextType.Type.IN_DOCUMENT;
    }

    boolean isInMap() {
        return this.peek().getType() == ParsingContextType.Type.IN_MAP;
    }

    boolean isInSimpleKey() {
        return this.peek().getType() == ParsingContextType.Type.IN_KEY;
    }

    boolean isInComplexKey() {
        return this.peek().getType() == ParsingContextType.Type.IN_COMPLEX_KEY;
    }

    boolean isInKey() {
        return this.isInSimpleKey() || this.isInComplexKey() || this.isInAliasKey();
    }

    boolean isInAliasKey() {
        return this.peek().getType() == ParsingContextType.Type.IN_ALIAS_KEY;
    }

    boolean isInSequence() {
        return this.peek().getType() == ParsingContextType.Type.IN_SEQUENCE;
    }

    boolean isInStream() {
        return this.peek().getType() == ParsingContextType.Type.IN_STREAM;
    }

    boolean isNotInStream() {
        return !this.isInStream();
    }

    public <T extends AbstractBaseNode> ParsingContextType<T> getParent() {
        ParsingContextType<? extends AbstractBaseNode> result = this.stack.get(1);
        return result;
    }

    public <T extends AbstractBaseNode> ParsingContextType<T> getCurrent() {
        return this.stack.getFirst();
    }

    public StreamNode getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(StreamNode node) {
        this.rootNode = node;
    }
}

