/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharIntAssociativeContainer;
import com.carrotsearch.hppc.CharIntHashMap;
import com.carrotsearch.hppc.CharIntMap;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.comparators.CharComparator;
import com.carrotsearch.hppc.comparators.CharIntComparator;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharIntCursor;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.predicates.CharIntPredicate;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.CharIntProcedure;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationCharIntHashMap
implements CharIntMap {
    public final CharIntHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationCharIntHashMap(CharIntHashMap delegate, CharComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationCharIntHashMap(CharIntHashMap delegate, CharIntComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        char[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != '\u0000') {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, CharComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            char[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final CharIntComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final char[] keys;
            final int[] values;
            {
                this.keys = SortedIterationCharIntHashMap.this.delegate.keys;
                this.values = SortedIterationCharIntHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<CharIntCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(CharContainer container) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharIntPredicate predicate) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public <T extends CharIntProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends CharIntPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        int[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public CharCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public IntContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public int get(char key) {
        return this.delegate.get(key);
    }

    @Override
    public int getOrDefault(char key, int defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public int put(char key, int value) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(CharIntAssociativeContainer container) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends CharIntCursor> iterable) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public int putOrAdd(char key, int putValue, int incrementValue) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public int addTo(char key, int additionValue) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public int remove(char key) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public int indexOf(char key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public int indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public int indexReplace(int index, int newValue) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, char key, int value) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public int indexRemove(int index) {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationCharIntHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<CharIntCursor> {
        private final CharIntCursor cursor = new CharIntCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected CharIntCursor fetch() {
            if (this.index < SortedIterationCharIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharIntHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationCharIntHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationCharIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharIntCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final SortedIterationCharIntHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationCharIntHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationCharIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationCharIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationCharIntHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final SortedIterationCharIntHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationCharIntHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(int value) {
            for (CharIntCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(int e) {
            throw SortedIterationCharIntHashMap.readOnlyException();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            throw SortedIterationCharIntHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationCharIntHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharIntHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor = new IntCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected IntCursor fetch() {
            if (this.index < SortedIterationCharIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharIntHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationCharIntHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharIntHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharIntHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

