/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.spi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.LinkedHashMap;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.util.control.TailCalls;
import scala.util.control.TailCalls$;
import ujson.Arr;
import ujson.Bool;
import ujson.Bool$;
import ujson.Null$;
import ujson.Num;
import ujson.Obj;
import ujson.Readable;
import ujson.Readable$;
import ujson.Str;
import ujson.Value;

public final class ujsonUtils$ {
    public static final ujsonUtils$ MODULE$ = new ujsonUtils$();
    private static final int DIGIT_THRESHOLD = 15;
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final ObjectMapper mapper = new ObjectMapper(MODULE$.jsonFactory()).enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS).enable(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS);
    private static final JsonNodeFactory nodeFactory = JsonNodeFactory.withExactBigDecimals((boolean)true);

    private int DIGIT_THRESHOLD() {
        return DIGIT_THRESHOLD;
    }

    private JsonFactory jsonFactory() {
        return jsonFactory;
    }

    private ObjectMapper mapper() {
        return mapper;
    }

    private JsonNodeFactory nodeFactory() {
        return nodeFactory;
    }

    public Str strValueOf(String str) {
        return new Str(str);
    }

    public String stringValueOf(Value value) {
        return String.valueOf(value.value());
    }

    public Value parse(String jsonData) {
        String processedJson = this.replaceLargeNumbers(jsonData);
        return ujson.package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(processedJson), ujson.package$.MODULE$.read$default$2());
    }

    public String replaceLargeNumbers(String jsonString) {
        String string;
        try {
            JsonNode rootNode = this.mapper().readTree(jsonString);
            JsonNode processedNode = this.processNode(rootNode);
            string = this.mapper().writeValueAsString((Object)processedNode);
        }
        catch (Exception e) {
            throw new Exception(new StringBuilder(22).append("Failed to parse JSON: ").append(e.getMessage()).toString(), e);
        }
        return string;
    }

    private JsonNode processNode(JsonNode node) {
        JsonNode jsonNode = node;
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            ObjectNode newNode = this.mapper().createObjectNode();
            CollectionConverters$.MODULE$.IteratorHasAsScala(objectNode.fields()).asScala().foreach((Function1 & Serializable)entry -> newNode.set((String)entry.getKey(), MODULE$.processNode((JsonNode)entry.getValue())));
            return newNode;
        }
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            ArrayNode newNode = this.mapper().createArrayNode();
            CollectionConverters$.MODULE$.IteratorHasAsScala(arrayNode.elements()).asScala().foreach((Function1 & Serializable)element -> newNode.add(MODULE$.processNode((JsonNode)element)));
            return newNode;
        }
        if (jsonNode instanceof NumericNode) {
            NumericNode numericNode = (NumericNode)jsonNode;
            String numberStr = numericNode.asText();
            String digitsOnly = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(numberStr), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)x$1)))));
            if (digitsOnly.length() > this.DIGIT_THRESHOLD()) {
                return new TextNode(new StringBuilder(13).append("__LARGE_INT__").append(numberStr).toString());
            }
            return numericNode;
        }
        return node;
    }

    public Value read(Readable s, boolean trace) {
        return ujson.package$.MODULE$.read(s, trace);
    }

    public boolean read$default$2() {
        return false;
    }

    public String write(Value t, int indent, boolean escapeUnicode) {
        return ujson.package$.MODULE$.write(t, indent, escapeUnicode);
    }

    public int write$default$2() {
        return -1;
    }

    public boolean write$default$3() {
        return false;
    }

    public void writeTo(Value t, Writer out, int indent, boolean escapeUnicode) {
        ujson.package$.MODULE$.writeTo(t, out, indent, escapeUnicode);
    }

    public int writeTo$default$3() {
        return -1;
    }

    public boolean writeTo$default$4() {
        return false;
    }

    public Object javaObjectFrom(Value node2) {
        Bool bool;
        Option option;
        Value value = node2;
        if (Null$.MODULE$.equals(value)) {
            return null;
        }
        if (value instanceof Bool && !(option = Bool$.MODULE$.unapply(bool = (Bool)value)).isEmpty()) {
            boolean value2 = BoxesRunTime.unboxToBoolean((Object)option.get());
            return BoxesRunTime.boxToBoolean((boolean)value2);
        }
        if (value instanceof Num) {
            Num num = (Num)value;
            double value3 = num.value();
            double num2 = value3;
            if (Math.ceil(num2) == Math.floor(num2)) {
                long longValue = (long)value3;
                if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE) {
                    return (int)value3;
                }
                return longValue;
            }
            return value3;
        }
        if (value instanceof Str) {
            Str str = (Str)value;
            String value4 = str.value();
            if (value4.startsWith("__LARGE_INT__")) {
                Number number;
                String numberStr = value4.substring("__LARGE_INT__".length());
                try {
                    number = Long.valueOf(numberStr);
                }
                catch (NumberFormatException numberFormatException) {
                    number = new BigInteger(numberStr);
                }
                return number;
            }
            return value4;
        }
        if (value instanceof Obj) {
            Obj obj = (Obj)value;
            LinkedHashMap value5 = obj.value();
            return CollectionConverters$.MODULE$.MapHasAsJava((Map)value5.map((Function1 & Serializable)keyVal -> new Tuple2(keyVal._1(), MODULE$.javaObjectFrom((Value)keyVal._2())))).asJava();
        }
        if (value instanceof Arr) {
            Arr arr = (Arr)value;
            ArrayBuffer value6 = arr.value();
            return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)value6.map((Function1 & Serializable)node -> MODULE$.javaObjectFrom((Value)node))).asJava();
        }
        throw new MatchError((Object)value);
    }

    public Object deepJavaObjectFrom(Value node) {
        return ujsonUtils$.tailrecObjFrom$1(node).result();
    }

    private static final /* synthetic */ Object liftedTree1$1(String numberStr$1) {
        Number number;
        try {
            number = Long.valueOf(numberStr$1);
        }
        catch (NumberFormatException numberFormatException) {
            number = new BigInteger(numberStr$1);
        }
        return number;
    }

    private static final TailCalls.TailRec tailrecObjFrom$1(Value node) {
        Bool bool;
        Option option;
        Value value = node;
        if (Null$.MODULE$.equals(value)) {
            return TailCalls$.MODULE$.done(null);
        }
        if (value instanceof Bool && !(option = Bool$.MODULE$.unapply(bool = (Bool)value)).isEmpty()) {
            boolean value2 = BoxesRunTime.unboxToBoolean((Object)option.get());
            return TailCalls$.MODULE$.done((Object)BoxesRunTime.boxToBoolean((boolean)value2));
        }
        if (value instanceof Num) {
            Num num = (Num)value;
            double value3 = num.value();
            return TailCalls$.MODULE$.done((Object)BoxesRunTime.boxToDouble((double)value3));
        }
        if (value instanceof Str) {
            Str str = (Str)value;
            String value4 = str.value();
            if (value4.startsWith("__LARGE_INT__")) {
                String numberStr = value4.substring("__LARGE_INT__".length());
                return TailCalls$.MODULE$.done(ujsonUtils$.liftedTree1$1(numberStr));
            }
            return TailCalls$.MODULE$.done((Object)value4);
        }
        if (value instanceof Obj) {
            Obj obj = (Obj)value;
            LinkedHashMap value5 = obj.value();
            return ((TailCalls.TailRec)value5.toList().foldRight((Object)TailCalls$.MODULE$.done((Object)package$.MODULE$.List().empty()), (Function2 & Serializable)(keyVal, tailrecEntrySet) -> tailrecEntrySet.flatMap((Function1 & Serializable)entrySet -> TailCalls$.MODULE$.tailcall((Function0 & Serializable)() -> ujsonUtils$.tailrecObjFrom$1((Value)keyVal._2())).map((Function1 & Serializable)javaObj -> entrySet.prepended((Object)new Tuple2(keyVal._1(), javaObj)))))).map((Function1 & Serializable)list -> CollectionConverters$.MODULE$.MapHasAsJava((Map)list.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava());
        }
        if (value instanceof Arr) {
            Arr arr = (Arr)value;
            ArrayBuffer value6 = arr.value();
            return ((TailCalls.TailRec)value6.foldRight((Object)TailCalls$.MODULE$.done((Object)package$.MODULE$.List().empty()), (Function2 & Serializable)(item, tailrecList) -> tailrecList.flatMap((Function1 & Serializable)list -> TailCalls$.MODULE$.tailcall((Function0 & Serializable)() -> ujsonUtils$.tailrecObjFrom$1(item)).map((Function1 & Serializable)javaObj -> list.$colon$colon(javaObj))))).map((Function1 & Serializable)list -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)list).asJava());
        }
        throw new MatchError((Object)value);
    }

    private ujsonUtils$() {
    }
}

