/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data;

import io.stargate.sdk.core.domain.Page;
import io.stargate.sdk.data.DataApiClient;
import io.stargate.sdk.data.domain.ApiData;
import io.stargate.sdk.data.domain.ApiError;
import io.stargate.sdk.data.domain.ApiResponse;
import io.stargate.sdk.data.domain.DocumentMutationResult;
import io.stargate.sdk.data.domain.DocumentMutationStatus;
import io.stargate.sdk.data.domain.JsonDocument;
import io.stargate.sdk.data.domain.JsonDocumentMutationResult;
import io.stargate.sdk.data.domain.JsonDocumentResult;
import io.stargate.sdk.data.domain.JsonResultUpdate;
import io.stargate.sdk.data.domain.UpdateStatus;
import io.stargate.sdk.data.domain.odm.Document;
import io.stargate.sdk.data.domain.odm.DocumentResult;
import io.stargate.sdk.data.domain.odm.DocumentResultMapper;
import io.stargate.sdk.data.domain.query.DeleteQuery;
import io.stargate.sdk.data.domain.query.Filter;
import io.stargate.sdk.data.domain.query.SelectQuery;
import io.stargate.sdk.data.domain.query.UpdateQuery;
import io.stargate.sdk.data.exception.DataApiDocumentAlreadyExistException;
import io.stargate.sdk.data.utils.DataApiUtils;
import io.stargate.sdk.http.LoadBalancedHttpClient;
import io.stargate.sdk.http.ServiceHttp;
import io.stargate.sdk.utils.AnsiUtils;
import io.stargate.sdk.utils.Assert;
import io.stargate.sdk.utils.JsonUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionClient {
    private static final Logger log = LoggerFactory.getLogger(CollectionClient.class);
    protected final LoadBalancedHttpClient stargateHttpClient;
    private final String namespace;
    private final String collection;
    private boolean insertManyOrdered = false;
    public Function<ServiceHttp, String> collectionResource = node -> DataApiClient.rootResource.apply((ServiceHttp)node) + "/" + this.getNamespace() + "/" + this.getCollection();

    public CollectionClient(LoadBalancedHttpClient httpClient, String namespace, String collection) {
        this.namespace = namespace;
        this.collection = collection;
        this.stargateHttpClient = httpClient;
        Assert.notNull((Object)collection, (String)"Collection");
        Assert.notNull((Object)namespace, (String)"Namespace");
    }

    public final JsonDocumentMutationResult insertOne(String json) {
        Assert.hasLength((String)json, (String)"Json input");
        return this.insertOne(new JsonDocument(json));
    }

    public final CompletableFuture<JsonDocumentMutationResult> insertOneAsync(String json) {
        return CompletableFuture.supplyAsync(() -> this.insertOne(json));
    }

    public final JsonDocumentMutationResult insertOne(@NonNull JsonDocument document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        DocumentMutationResult<Map<String, Object>> mutationResult = this.insertOne((Document)document);
        JsonDocumentMutationResult res = new JsonDocumentMutationResult();
        res.setStatus(mutationResult.getStatus());
        res.setDocument(mutationResult.getDocument());
        return res;
    }

    public final CompletableFuture<JsonDocumentMutationResult> insertOneAsync(@NonNull JsonDocument document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> this.insertOne(document));
    }

    public final <T> DocumentMutationResult<T> insertOne(@NonNull Document<T> document) {
        ApiResponse response;
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        log.debug("insert into {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        if (document.getId() == null) {
            document.setId(UUID.randomUUID().toString());
        }
        if ((response = this.execute("insertOne", Map.of("document", document))).getErrors() != null && !response.getErrors().isEmpty()) {
            throw new DataApiDocumentAlreadyExistException(response.getErrors().get(0));
        }
        return new DocumentMutationResult<T>(document, DocumentMutationStatus.CREATED);
    }

    public final <T> CompletableFuture<DocumentMutationResult<T>> insertOneASync(@NonNull Document<T> document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> this.insertOne(document));
    }

    public final JsonDocumentMutationResult upsertOne(String json) {
        Assert.hasLength((String)json, (String)"Json input");
        return this.upsertOne(new JsonDocument(json));
    }

    public final CompletableFuture<JsonDocumentMutationResult> upsertOneAsync(String json) {
        return CompletableFuture.supplyAsync(() -> this.upsertOne(json));
    }

    public final JsonDocumentMutationResult upsertOne(@NonNull JsonDocument document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        DocumentMutationResult<Map<String, Object>> mutationResult = this.upsertOne((Document)document);
        JsonDocumentMutationResult res = new JsonDocumentMutationResult();
        res.setStatus(mutationResult.getStatus());
        res.setDocument(mutationResult.getDocument());
        return res;
    }

    public final CompletableFuture<JsonDocumentMutationResult> upsertOneAsync(@NonNull JsonDocument document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> this.upsertOne(document));
    }

    public <DOC> DocumentMutationResult<DOC> upsertOne(@NonNull Document<DOC> document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        log.debug("upsert into {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        if (document.getId() == null) {
            document.setId(UUID.randomUUID().toString());
        }
        JsonResultUpdate u = this.findOneAndReplace(UpdateQuery.builder().where("_id").isEqualsTo(document.getId()).replaceBy(document).withUpsert().build());
        DocumentMutationResult<DOC> result = new DocumentMutationResult<DOC>(document);
        if (u.getUpdateStatus().getUpsertedId() != null && u.getUpdateStatus().getUpsertedId().equals(document.getId())) {
            result.setStatus(DocumentMutationStatus.CREATED);
        } else if (u.getUpdateStatus().getModifiedCount() == 0) {
            result.setStatus(DocumentMutationStatus.UNCHANGED);
        } else {
            result.setStatus(DocumentMutationStatus.UPDATED);
        }
        return result;
    }

    public <DOC> CompletableFuture<DocumentMutationResult<DOC>> upsertOneASync(@NonNull Document<DOC> document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> this.upsertOne(document));
    }

    public final List<JsonDocumentMutationResult> insertMany(String json) {
        return this.insertManyJsonDocuments(this.mapJsonStringToJsonDocumentList(json));
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> insertManyASync(String json) {
        return CompletableFuture.supplyAsync(() -> this.insertMany(json));
    }

    public final List<JsonDocumentMutationResult> insertManyJsonDocuments(List<JsonDocument> documents) {
        return this.mapJsonDocumentMutationResultList(this.insertMany(this.mapJsonDocumentList(documents)));
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> insertManyJsonDocumentsASync(List<JsonDocument> documents) {
        return CompletableFuture.supplyAsync(() -> this.insertManyJsonDocuments(documents));
    }

    public final <DOC> List<DocumentMutationResult<DOC>> insertMany(List<Document<DOC>> documents) {
        return this.insertMany(documents, false);
    }

    public final <DOC> CompletableFuture<List<DocumentMutationResult<DOC>>> insertManyASync(List<Document<DOC>> documents) {
        return CompletableFuture.supplyAsync(() -> this.insertMany(documents));
    }

    public final List<JsonDocumentMutationResult> upsertMany(String json) {
        return this.upsertManyJsonDocuments(this.mapJsonStringToJsonDocumentList(json));
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> upsertManyASync(String json) {
        return CompletableFuture.supplyAsync(() -> this.upsertMany(json));
    }

    public final List<JsonDocumentMutationResult> upsertManyJsonDocuments(List<JsonDocument> documents) {
        return this.mapJsonDocumentMutationResultList(this.upsertMany(this.mapJsonDocumentList(documents)));
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> upsertManyJsonDocumentsASync(List<JsonDocument> documents) {
        return CompletableFuture.supplyAsync(() -> this.upsertManyJsonDocuments(documents));
    }

    public final <DOC> List<DocumentMutationResult<DOC>> upsertMany(List<Document<DOC>> documents) {
        return this.insertMany(documents, true);
    }

    public final <DOC> CompletableFuture<List<DocumentMutationResult<DOC>>> upsertManyASync(List<Document<DOC>> documents) {
        return CompletableFuture.supplyAsync(() -> this.upsertMany(documents));
    }

    private <DOC> List<DocumentMutationResult<DOC>> insertMany(List<Document<DOC>> documents, boolean replaceIfExists) {
        if (documents != null && !documents.isEmpty()) {
            log.debug("insert many (size={},ordered={}) into {}/{}", new Object[]{AnsiUtils.green((String)String.valueOf(documents.size())), AnsiUtils.green((String)String.valueOf(this.insertManyOrdered)), AnsiUtils.green((String)this.namespace), AnsiUtils.green((String)this.collection)});
            Map results = CollectionClient.initResultMap(documents);
            ApiResponse apiResponse = this.execute("insertMany", Map.of("documents", documents, "options", Map.of("ordered", this.insertManyOrdered)));
            DataApiUtils.validate(apiResponse);
            if (apiResponse.getStatus() != null) {
                Optional.ofNullable(apiResponse.getStatus().get("insertedIds")).ifPresent(ids -> ((List)ids).forEach(id -> results.computeIfPresent((String)id, (k, v) -> {
                    v.setStatus(DocumentMutationStatus.CREATED);
                    return v;
                })));
            }
            if (apiResponse.getErrors() != null) {
                Pattern pattern = Pattern.compile("'(.*?)'");
                apiResponse.getErrors().stream().filter(error -> "DOCUMENT_ALREADY_EXISTS".equals(error.getErrorCode())).map(ApiError::getMessage).map(msg -> pattern.matcher((CharSequence)msg)).filter(Matcher::find).map(matcher -> matcher.group(1)).forEach(id -> results.computeIfPresent((String)id, (k, v) -> {
                    v.setStatus(DocumentMutationStatus.ALREADY_EXISTS);
                    return v;
                }));
            }
            if (replaceIfExists) {
                ExecutorService executor = Executors.newFixedThreadPool(10);
                results.values().stream().filter(r -> DocumentMutationStatus.ALREADY_EXISTS.equals((Object)r.getStatus())).forEach(r -> executor.submit(() -> {
                    JsonResultUpdate u = this.findOneAndReplace(UpdateQuery.builder().where("_id").isEqualsTo(r.getDocument().getId()).replaceBy(r.getDocument()).build());
                    if (u.getUpdateStatus().getModifiedCount() == 0) {
                        r.setStatus(DocumentMutationStatus.UNCHANGED);
                    } else {
                        r.setStatus(DocumentMutationStatus.UPDATED);
                    }
                }));
                executor.shutdown();
                try {
                    boolean bl = executor.awaitTermination(20L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return new ArrayList<DocumentMutationResult<DOC>>(results.values());
        }
        return new ArrayList<DocumentMutationResult<DOC>>();
    }

    public final List<JsonDocumentMutationResult> insertManyChunked(String json, int chunkSize, int concurrency) {
        return this.insertManyJsonDocumentsChunked(this.mapJsonStringToJsonDocumentList(json), chunkSize, concurrency);
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> insertManyChunkedASync(String json, int chunkSize, int concurrency) {
        return CompletableFuture.supplyAsync(() -> this.insertManyChunked(json, chunkSize, concurrency));
    }

    public final List<JsonDocumentMutationResult> insertManyJsonDocumentsChunked(List<JsonDocument> documents, int chunkSize, int concurrency) {
        return this.mapJsonDocumentMutationResultList(this.insertManyChunked(this.mapJsonDocumentList(documents), chunkSize, concurrency));
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> insertManyJsonDocumentsChunkedASync(List<JsonDocument> documents, int chunkSize, int concurrency) {
        return CompletableFuture.supplyAsync(() -> this.insertManyJsonDocumentsChunked(documents, chunkSize, concurrency));
    }

    public final <DOC> List<DocumentMutationResult<DOC>> insertManyChunked(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return this.insertManyChunked(documents, chunkSize, concurrency, false);
    }

    public final <DOC> CompletableFuture<List<DocumentMutationResult<DOC>>> insertManyChunkedASync(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return CompletableFuture.supplyAsync(() -> this.insertManyChunked(documents, chunkSize, concurrency));
    }

    public final List<JsonDocumentMutationResult> upsertManyChunked(String json, int chunkSize, int concurrency) {
        return this.upsertManyJsonDocumentsChunked(this.mapJsonStringToJsonDocumentList(json), chunkSize, concurrency);
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> upsertManyChunkedASync(String json, int chunkSize, int concurrency) {
        return CompletableFuture.supplyAsync(() -> this.upsertManyChunked(json, chunkSize, concurrency));
    }

    public final List<JsonDocumentMutationResult> upsertManyJsonDocumentsChunked(List<JsonDocument> documents, int chunkSize, int concurrency) {
        return this.mapJsonDocumentMutationResultList(this.insertManyChunked(this.mapJsonDocumentList(documents), chunkSize, concurrency));
    }

    public final CompletableFuture<List<JsonDocumentMutationResult>> upsertManyJsonDocumentsChunkedASync(List<JsonDocument> documents, int chunkSize, int concurrency) {
        return CompletableFuture.supplyAsync(() -> this.upsertManyJsonDocumentsChunked(documents, chunkSize, concurrency));
    }

    public final <DOC> List<DocumentMutationResult<DOC>> upsertManyChunked(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return this.insertManyChunked(documents, chunkSize, concurrency, true);
    }

    public final <DOC> CompletableFuture<List<DocumentMutationResult<DOC>>> upsertManyChunkedASync(List<Document<DOC>> documents, int chunkSize, int concurrency) {
        return CompletableFuture.supplyAsync(() -> this.upsertManyChunked(documents, chunkSize, concurrency));
    }

    private final <DOC> List<DocumentMutationResult<DOC>> insertManyChunked(List<Document<DOC>> documents, int chunkSize, int concurrency, boolean replaceIfExists) {
        if (chunkSize < 1 || chunkSize > 20) {
            throw new IllegalArgumentException("ChunkSize must be between 1 and 20");
        }
        if (concurrency < 1 || concurrency > 50) {
            throw new IllegalArgumentException("Concurrency must be between 1 and 50");
        }
        Map<String, DocumentMutationResult<DOC>> results = CollectionClient.initResultMap(documents);
        ExecutorService executor = Executors.newFixedThreadPool(concurrency);
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        for (int i = 0; i < documents.size(); i += chunkSize) {
            int n = i;
            int end = Math.min(i + chunkSize, documents.size());
            Callable<List> task = () -> {
                log.debug("insert block (size={}) {}/{}", new Object[]{end - start, AnsiUtils.green((String)this.namespace), AnsiUtils.green((String)this.collection)});
                return this.insertMany(documents.subList(start, end), replaceIfExists);
            };
            futures.add(executor.submit(task));
        }
        for (Future future : futures) {
            try {
                ((List)future.get()).stream().forEach(r -> results.computeIfPresent(r.getDocument().getId(), (k, v) -> {
                    v.setStatus(r.getStatus());
                    return v;
                }));
            }
            catch (Exception e) {
                throw new RuntimeException("Error when process a block", e);
            }
        }
        return new ArrayList<DocumentMutationResult<DOC>>(results.values());
    }

    public Integer countDocuments() {
        return this.countDocuments(null);
    }

    public Integer countDocuments(Filter jsonFilter) {
        log.debug("Counting {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        return this.execute("countDocuments", jsonFilter).getStatusKeyAsInt("count");
    }

    public boolean isDocumentExists(String id) {
        return this.findOne(SelectQuery.builder().select("_id").where("_id").isEqualsTo(id).build()).isPresent();
    }

    public Optional<JsonDocumentResult> findOne(SelectQuery query) {
        log.debug("Query in {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        return Optional.ofNullable(this.execute("findOne", query).getData().getDocument());
    }

    public Optional<JsonDocumentResult> findOne(String rawJsonQuery) {
        log.debug("Query in {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        return Optional.ofNullable(this.execute("findOne", rawJsonQuery).getData().getDocument());
    }

    public <DOC> Optional<DocumentResult<DOC>> findOne(String query, Class<DOC> clazz) {
        return this.findOne(query).map(r -> new DocumentResult((JsonDocumentResult)r, clazz));
    }

    public <DOC> Optional<DocumentResult<DOC>> findOne(String query, DocumentResultMapper<DOC> mapper) {
        return this.findOne(query).map(mapper::map);
    }

    public <DOC> Optional<DocumentResult<DOC>> findOne(SelectQuery query, Class<DOC> clazz) {
        return this.findOne(query).map(r -> new DocumentResult((JsonDocumentResult)r, clazz));
    }

    public <DOC> Optional<DocumentResult<DOC>> findOne(SelectQuery query, DocumentResultMapper<DOC> mapper) {
        return this.findOne(query).map(mapper::map);
    }

    public Optional<JsonDocumentResult> findById(String id) {
        return this.findOne(SelectQuery.findById(id));
    }

    public <DOC> Optional<DocumentResult<DOC>> findById(@NonNull String id, Class<DOC> clazz) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.findById(id).map(r -> new DocumentResult((JsonDocumentResult)r, clazz));
    }

    public <DOC> Optional<DocumentResult<DOC>> findById(@NonNull String id, DocumentResultMapper<DOC> mapper) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.findById(id).map(mapper::map);
    }

    public Optional<JsonDocumentResult> findOneByVector(float[] vector) {
        return this.findOne(SelectQuery.findByVector(vector));
    }

    public <DOC> Optional<DocumentResult<DOC>> findOneByVector(float[] vector, Class<DOC> clazz) {
        return this.findOneByVector(vector).map(r -> new DocumentResult((JsonDocumentResult)r, clazz));
    }

    public <DOC> Optional<DocumentResult<DOC>> findOneByVector(float[] vector, DocumentResultMapper<DOC> mapper) {
        return this.findOneByVector(vector).map(mapper::map);
    }

    public Stream<JsonDocumentResult> find(SelectQuery query) {
        ArrayList documents = new ArrayList();
        String pageState = null;
        AtomicInteger pageCount = new AtomicInteger(0);
        do {
            log.debug("Fetching page " + pageCount.incrementAndGet());
            Page<JsonDocumentResult> pageX = this.findPage(query);
            pageState = pageX.getPageState().orElse(null);
            if (query.getLimit().isPresent() && documents.size() + pageX.getResults().size() > query.getLimit().get()) {
                documents.addAll(pageX.getResults().subList(0, query.getLimit().get() - documents.size()));
                break;
            }
            documents.addAll(pageX.getResults());
            query.setPageState(pageState);
        } while (pageState != null);
        return documents.stream();
    }

    public Page<JsonDocumentResult> findPage(SelectQuery query) {
        log.debug("Query in {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        ApiData apiData = this.execute("find", query).getData();
        int pageSize = query != null && query.getLimit().isPresent() ? query.getLimit().get() : 20;
        return new Page(pageSize, apiData.getNextPageState(), apiData.getDocuments());
    }

    public Page<JsonDocumentResult> findPage(String query) {
        log.debug("Query in {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        ApiData apiData = this.execute("find", query).getData();
        return new Page(20, apiData.getNextPageState(), apiData.getDocuments());
    }

    public Stream<JsonDocumentResult> findVector(float[] vector, Integer limit) {
        return this.findVector(vector, null, limit);
    }

    public Stream<JsonDocumentResult> findVector(float[] vector, Filter filter, Integer limit) {
        return this.find(SelectQuery.builder().withFilter(filter).orderByAnn(vector).withLimit(limit).includeSimilarity().build());
    }

    public Page<JsonDocumentResult> findVectorPage(SelectQuery query) {
        return this.findPage(query);
    }

    public Page<JsonDocumentResult> findVectorPage(float[] vector, Filter filter, Integer limit, String pagingState) {
        return this.findVectorPage(SelectQuery.builder().withFilter(filter).orderByAnn(vector).withLimit(limit).withPagingState(pagingState).includeSimilarity().build());
    }

    public <DOC> Page<DocumentResult<DOC>> findVectorPage(float[] vector, Filter filter, Integer limit, String pagingState, Class<DOC> clazz) {
        return this.mapPageJsonResultAsPageResult(this.findVectorPage(vector, filter, limit, pagingState), clazz);
    }

    public <DOC> Page<DocumentResult<DOC>> findVectorPage(float[] vector, Filter filter, Integer limit, String pagingState, DocumentResultMapper<DOC> mapper) {
        return this.mapPageJsonResultAsPageResult(this.findVectorPage(vector, filter, limit, pagingState), mapper);
    }

    public <DOC> Stream<DocumentResult<DOC>> find(SelectQuery query, Class<DOC> clazz) {
        return this.find(query).map(r -> new DocumentResult((JsonDocumentResult)r, clazz));
    }

    public <DOC> Stream<DocumentResult<DOC>> find(SelectQuery pageQuery, DocumentResultMapper<DOC> mapper) {
        return this.find(pageQuery).map(mapper::map);
    }

    public Stream<JsonDocumentResult> findAll() {
        return this.find(SelectQuery.builder().build());
    }

    public <DOC> Stream<DocumentResult<DOC>> findAll(Class<DOC> clazz) {
        return this.findAll().map(r -> new DocumentResult((JsonDocumentResult)r, clazz));
    }

    public <DOC> Stream<DocumentResult<DOC>> findAll(DocumentResultMapper<DOC> mapper) {
        return this.findAll().map(mapper::map);
    }

    public <DOC> Page<DocumentResult<DOC>> findPage(SelectQuery query, Class<DOC> clazz) {
        return this.mapPageJsonResultAsPageResult(this.findPage(query), clazz);
    }

    public <DOC> Page<DocumentResult<DOC>> findPage(String query, Class<DOC> clazz) {
        return this.mapPageJsonResultAsPageResult(this.findPage(query), clazz);
    }

    public <DOC> Page<DocumentResult<DOC>> findPage(SelectQuery query, DocumentResultMapper<DOC> mapper) {
        return this.mapPageJsonResultAsPageResult(this.findPage(query), mapper);
    }

    public <DOC> Page<DocumentResult<DOC>> findPage(String query, DocumentResultMapper<DOC> mapper) {
        return this.mapPageJsonResultAsPageResult(this.findPage(query), mapper);
    }

    public <DOC> Page<DocumentResult<DOC>> mapPageJsonResultAsPageResult(Page<JsonDocumentResult> pageJson, Class<DOC> clazz) {
        return new Page(pageJson.getPageSize(), (String)pageJson.getPageState().orElse(null), pageJson.getResults().stream().map(r -> new DocumentResult((JsonDocumentResult)r, clazz)).collect(Collectors.toList()));
    }

    public <DOC> Page<DocumentResult<DOC>> mapPageJsonResultAsPageResult(Page<JsonDocumentResult> pageJson, DocumentResultMapper<DOC> mapper) {
        return new Page(pageJson.getPageSize(), (String)pageJson.getPageState().orElse(null), pageJson.getResults().stream().map(mapper::map).collect(Collectors.toList()));
    }

    public int deleteOne(DeleteQuery deleteQuery) {
        log.debug("Delete in {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        return this.execute("deleteOne", deleteQuery).getStatusKeyAsInt("deletedCount");
    }

    public int deleteById(String id) {
        return this.deleteOne(DeleteQuery.deleteById(id));
    }

    public int deleteByVector(float[] vector) {
        return this.deleteOne(DeleteQuery.deleteByVector(vector));
    }

    public int deleteMany(DeleteQuery deleteQuery) {
        log.debug("Delete in {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        return this.execute("deleteMany", deleteQuery).getStatusKeyAsInt("deletedCount");
    }

    public int deleteAll() {
        return this.deleteMany(null);
    }

    public JsonResultUpdate findOneAndUpdate(UpdateQuery query) {
        return this.updateQuery("findOneAndUpdate", query);
    }

    public JsonResultUpdate findOneAndReplace(UpdateQuery query) {
        return this.updateQuery("findOneAndReplace", query);
    }

    public JsonResultUpdate findOneAndDelete(UpdateQuery query) {
        return this.updateQuery("findOneAndDelete", query);
    }

    private JsonResultUpdate updateQuery(String operation, UpdateQuery query) {
        log.debug("{} in {}/{}", new Object[]{operation, AnsiUtils.green((String)this.namespace), AnsiUtils.green((String)this.collection)});
        ApiResponse response = this.execute(operation, query);
        JsonResultUpdate jru = new JsonResultUpdate();
        if (response.getData() != null) {
            jru.setJsonResult(response.getData().getDocument());
        }
        if (response.getStatus() != null) {
            jru.setUpdateStatus(this.buildUpdateStatus(response.getStatus()));
        }
        return jru;
    }

    private UpdateStatus buildUpdateStatus(Map<String, Object> status) {
        UpdateStatus updateStatus = new UpdateStatus();
        status.computeIfPresent("upsertedId", (k, v) -> {
            updateStatus.setUpsertedId(v.toString());
            return v;
        });
        status.computeIfPresent("modifiedCount", (k, v) -> {
            updateStatus.setModifiedCount((Integer)v);
            return v;
        });
        status.computeIfPresent("matchedCount", (k, v) -> {
            updateStatus.setMatchedCount((Integer)v);
            return v;
        });
        status.computeIfPresent("deletedCount", (k, v) -> {
            updateStatus.setDeletedCount((Integer)v);
            return v;
        });
        return updateStatus;
    }

    public UpdateStatus updateOne(UpdateQuery query) {
        log.debug("updateOne in {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        return this.updateQuery("updateOne", query).getUpdateStatus();
    }

    public UpdateStatus updateMany(UpdateQuery query) {
        log.debug("updateMany in {}/{}", (Object)AnsiUtils.green((String)this.namespace), (Object)AnsiUtils.green((String)this.collection));
        return this.updateQuery("updateMany", query).getUpdateStatus();
    }

    @NotNull
    private static <DOC> Map<String, DocumentMutationResult<DOC>> initResultMap(List<Document<DOC>> documents) {
        LinkedHashMap results = new LinkedHashMap(documents.size());
        documents.forEach(d -> {
            if (d.getId() == null) {
                d.setId(UUID.randomUUID().toString());
            }
            results.put(d.getId(), new DocumentMutationResult(d));
        });
        return results;
    }

    private List<Document<Map<String, Object>>> mapJsonDocumentList(List<JsonDocument> documents) {
        return documents.stream().map(d -> d).collect(Collectors.toList());
    }

    private List<JsonDocumentMutationResult> mapJsonDocumentMutationResultList(List<DocumentMutationResult<Map<String, Object>>> list) {
        return list.stream().map(DocumentMutationResult::asJsonDocumentMutationResult).collect(Collectors.toList());
    }

    private List<JsonDocument> mapJsonStringToJsonDocumentList(String json) {
        List kvList = (List)JsonUtils.unmarshallBeanForDataApi((String)json, List.class);
        return kvList.stream().map(JsonDocument::new).collect(Collectors.toList());
    }

    private ApiResponse execute(String operation, Object payload) {
        return DataApiUtils.executeOperation(this.stargateHttpClient, this.collectionResource, operation, payload);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getCollection() {
        return this.collection;
    }

    public boolean isInsertManyOrdered() {
        return this.insertManyOrdered;
    }

    public void setInsertManyOrdered(boolean insertManyOrdered) {
        this.insertManyOrdered = insertManyOrdered;
    }
}

