/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import io.stargate.sdk.data.domain.ApiData;
import io.stargate.sdk.data.domain.ApiError;
import io.stargate.sdk.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.NonNull;

public class ApiResponse {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Map<String, Object> status;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ApiError> errors;
    private ApiData data;

    public Stream<String> getStatusKeyAsStringStream(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (this.status.containsKey(key)) {
            return ((ArrayList)this.status.get(key)).stream();
        }
        return Stream.empty();
    }

    public <T> T getStatusKeyAsObject(@NonNull String key, @NonNull Class<T> targetClass) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (targetClass == null) {
            throw new NullPointerException("targetClass is marked non-null but is null");
        }
        if (this.status.containsKey(key)) {
            return (T)JsonUtils.convertValue((Object)this.status.get(key), targetClass);
        }
        return null;
    }

    public <T> List<T> getStatusKeyAsList(@NonNull String key, Class<T> targetClass) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (this.status.containsKey(key)) {
            return (List)JsonUtils.getObjectMapper().convertValue(this.status.get(key), (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructCollectionType(List.class, targetClass));
        }
        return null;
    }

    public Integer getStatusKeyAsInt(@NonNull String key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (this.status.containsKey(key)) {
            return (Integer)this.status.get(key);
        }
        throw new IllegalArgumentException("Key '" + key + "' does not exist in status");
    }

    public Map<String, Object> getStatus() {
        return this.status;
    }

    public List<ApiError> getErrors() {
        return this.errors;
    }

    public ApiData getData() {
        return this.data;
    }

    public void setStatus(Map<String, Object> status) {
        this.status = status;
    }

    public void setErrors(List<ApiError> errors) {
        this.errors = errors;
    }

    public void setData(ApiData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResponse)) {
            return false;
        }
        ApiResponse other = (ApiResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$status = this.getStatus();
        Map<String, Object> other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        List<ApiError> this$errors = this.getErrors();
        List<ApiError> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        ApiData this$data = this.getData();
        ApiData other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        List<ApiError> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        ApiData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "ApiResponse(status=" + String.valueOf(this.getStatus()) + ", errors=" + String.valueOf(this.getErrors()) + ", data=" + String.valueOf(this.getData()) + ")";
    }
}

