/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class NamespaceDefinition {
    private String name;
    private Options options;

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamespaceDefinition)) {
            return false;
        }
        NamespaceDefinition other = (NamespaceDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NamespaceDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    public String toString() {
        return "NamespaceDefinition(name=" + this.getName() + ", options=" + String.valueOf(this.getOptions()) + ")";
    }

    public static class Builder {
        final NamespaceDefinition config = new NamespaceDefinition();

        public Builder name(String name) {
            this.config.name = name;
            return this;
        }

        public Builder simpleStrategy(int replicationFactor) {
            this.replicationStrategy(ReplicationStrategy.SimpleStrategy);
            this.withOption("replication_factor", replicationFactor);
            return this;
        }

        public Builder networkTopologyStrategy(Map<String, Integer> datacenters) {
            this.replicationStrategy(ReplicationStrategy.NetworkTopologyStrategy);
            datacenters.forEach((dc, rf) -> this.withOption((String)dc, (Integer)rf));
            return this;
        }

        public Builder replicationStrategy(ReplicationStrategy clazz) {
            if (this.config.options == null) {
                this.config.options = new Options();
                this.config.options.replication = new Replication();
            }
            this.config.options.replication.clazz = clazz;
            return this;
        }

        public Builder withOption(String key, Integer value) {
            if (this.config.options == null) {
                this.config.options = new Options();
                this.config.options.replication = new Replication();
            }
            this.config.options.replication.strategyOptions.put(key, value);
            return this;
        }

        public NamespaceDefinition build() {
            return this.config;
        }
    }

    public static class Options {
        private Replication replication;

        public Replication getReplication() {
            return this.replication;
        }

        public void setReplication(Replication replication) {
            this.replication = replication;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Replication this$replication = this.getReplication();
            Replication other$replication = other.getReplication();
            return !(this$replication == null ? other$replication != null : !this$replication.equals(other$replication));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Replication $replication = this.getReplication();
            result = result * 59 + ($replication == null ? 43 : $replication.hashCode());
            return result;
        }

        public String toString() {
            return "NamespaceDefinition.Options(replication=" + String.valueOf(this.getReplication()) + ")";
        }
    }

    public static class Replication {
        @JsonProperty(value="class")
        private ReplicationStrategy clazz;
        @JsonAnyGetter
        private Map<String, Integer> strategyOptions = new HashMap<String, Integer>();
    }

    public static enum ReplicationStrategy {
        SimpleStrategy,
        NetworkTopologyStrategy;

    }
}

