/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import io.stargate.sdk.data.domain.query.DeleteQueryBuilder;
import io.stargate.sdk.http.domain.FilterKeyword;
import io.stargate.sdk.http.domain.FilterOperator;
import java.util.Map;

public class DeleteQueryFilterBuilder {
    private final String fieldName;
    private final DeleteQueryBuilder builder;

    protected DeleteQueryFilterBuilder(DeleteQueryBuilder builder, String fieldName) {
        this.builder = builder;
        this.fieldName = fieldName;
    }

    private DeleteQueryBuilder simpleOperator(FilterOperator cond, Object value) {
        this.builder.filter.put(this.fieldName, Map.of(cond.getOperator(), value));
        return this.builder;
    }

    private DeleteQueryBuilder simpleKeyword(FilterKeyword key, Object value) {
        this.builder.filter.put(this.fieldName, Map.of(key.getKeyword(), value));
        return this.builder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeleteQueryBuilder isEqualsTo(Object value) {
        if (FilterKeyword.VECTOR.getKeyword().equals(this.fieldName)) {
            if (!(value instanceof float[])) throw new IllegalArgumentException("Vector must be an array of float");
            this.builder.orderByAnn((float[])value);
            return this.builder;
        } else {
            this.builder.filter.put(this.fieldName, value);
        }
        return this.builder;
    }

    public DeleteQueryBuilder isAnArrayContaining(Object[] value) {
        return this.simpleOperator(FilterOperator.EQUALS_TO, value);
    }

    public DeleteQueryBuilder isAnArrayExactlyEqualsTo(Object[] value) {
        this.builder.filter.put(this.fieldName, Map.of(FilterKeyword.ALL.getKeyword(), value));
        return this.builder;
    }

    public DeleteQueryBuilder hasSubFieldsEqualsTo(Map<String, Object> value) {
        return this.simpleOperator(FilterOperator.EQUALS_TO, value);
    }

    public DeleteQueryBuilder isLessThan(Object value) {
        return this.simpleOperator(FilterOperator.LESS_THAN, value);
    }

    public DeleteQueryBuilder isLessOrEqualsThan(Object value) {
        return this.simpleOperator(FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
    }

    public DeleteQueryBuilder isGreaterThan(Object value) {
        return this.simpleOperator(FilterOperator.GREATER_THAN, value);
    }

    public DeleteQueryBuilder isGreaterOrEqualsThan(Object value) {
        return this.simpleOperator(FilterOperator.GREATER_THAN_OR_EQUALS_TO, value);
    }

    public DeleteQueryBuilder isNotEqualsTo(Object value) {
        return this.simpleOperator(FilterOperator.NOT_EQUALS_TO, value);
    }

    public DeleteQueryBuilder exists() {
        return this.simpleKeyword(FilterKeyword.EXISTS, true);
    }

    public DeleteQueryBuilder hasSize(int size) {
        return this.simpleKeyword(FilterKeyword.SIZE, true);
    }
}

