/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.data.domain.query;

import io.stargate.sdk.data.domain.query.SelectQueryBuilder;
import io.stargate.sdk.http.domain.FilterKeyword;
import io.stargate.sdk.http.domain.FilterOperator;
import java.util.Map;

public class SelectQueryFilterBuilder {
    private final String fieldName;
    private final SelectQueryBuilder builder;

    protected SelectQueryFilterBuilder(SelectQueryBuilder builder, String fieldName) {
        this.builder = builder;
        this.fieldName = fieldName;
    }

    private SelectQueryBuilder simpleOperator(FilterOperator cond, Object value) {
        this.builder.filter.put(this.fieldName, Map.of(cond.getOperator(), value));
        return this.builder;
    }

    private SelectQueryBuilder simpleKeyword(FilterKeyword key, Object value) {
        this.builder.filter.put(this.fieldName, Map.of(key.getKeyword(), value));
        return this.builder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SelectQueryBuilder isEqualsTo(Object value) {
        if (this.fieldName.equals(FilterKeyword.VECTOR.getKeyword())) {
            if (!(value instanceof float[])) throw new IllegalArgumentException("Vector must be an array of float");
            this.builder.orderByAnn((float[])value);
            return this.builder;
        } else {
            this.builder.filter.put(this.fieldName, value);
        }
        return this.builder;
    }

    public SelectQueryBuilder isInArray(Object[] value) {
        return this.simpleOperator(FilterOperator.IN, value);
    }

    public SelectQueryBuilder isNotInArray(Object[] value) {
        return this.simpleOperator(FilterOperator.NOT_IN, value);
    }

    public SelectQueryBuilder isAnArrayExactlyEqualsTo(Object[] value) {
        this.builder.filter.put(this.fieldName, Map.of(FilterKeyword.ALL.getKeyword(), value));
        return this.builder;
    }

    public SelectQueryBuilder hasSubFieldsEqualsTo(Map<String, Object> value) {
        return this.simpleOperator(FilterOperator.EQUALS_TO, value);
    }

    public SelectQueryBuilder isLessThan(Object value) {
        return this.simpleOperator(FilterOperator.LESS_THAN, value);
    }

    public SelectQueryBuilder isLessOrEqualsThan(Object value) {
        return this.simpleOperator(FilterOperator.LESS_THAN_OR_EQUALS_TO, value);
    }

    public SelectQueryBuilder isGreaterThan(Object value) {
        return this.simpleOperator(FilterOperator.GREATER_THAN, value);
    }

    public SelectQueryBuilder isGreaterOrEqualsThan(Object value) {
        return this.simpleOperator(FilterOperator.GREATER_THAN_OR_EQUALS_TO, value);
    }

    public SelectQueryBuilder isNotEqualsTo(Object value) {
        return this.simpleOperator(FilterOperator.NOT_EQUALS_TO, value);
    }

    public SelectQueryBuilder exists() {
        return this.simpleKeyword(FilterKeyword.EXISTS, true);
    }

    public SelectQueryBuilder hasSize(int size) {
        return this.simpleKeyword(FilterKeyword.SIZE, size);
    }
}

