/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt;

import com.facebook.ktfmt.FormatterKt;
import com.facebook.ktfmt.MainKt;
import com.facebook.ktfmt.ParseError;
import com.facebook.ktfmt.ParsedArgs;
import com.facebook.ktfmt.ParsedArgsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.FormattingError;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/ktfmt/Main;", "", "input", "Ljava/io/InputStream;", "out", "Ljava/io/PrintStream;", "err", "args", "", "", "(Ljava/io/InputStream;Ljava/io/PrintStream;Ljava/io/PrintStream;[Ljava/lang/String;)V", "parsedArgs", "Lcom/facebook/ktfmt/ParsedArgs;", "formatFile", "", "file", "Ljava/io/File;", "formatStdin", "handleParseError", "", "fileName", "e", "Lcom/facebook/ktfmt/ParseError;", "run", "", "ktfmt"})
public final class Main {
    @NotNull
    private final InputStream input;
    @NotNull
    private final PrintStream out;
    @NotNull
    private final PrintStream err;
    @NotNull
    private final ParsedArgs parsedArgs;

    public Main(@NotNull InputStream input, @NotNull PrintStream out, @NotNull PrintStream err, @NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.input = input;
        this.out = out;
        this.err = err;
        this.parsedArgs = ParsedArgsKt.parseOptions(this.err, args);
    }

    public final int run() {
        if (this.parsedArgs.getFileNames().isEmpty()) {
            this.err.println("Usage: ktfmt [--dropbox-style | --google-style | --kotlinlang-style] File1.kt File2.kt ...");
            return 1;
        }
        if (this.parsedArgs.getFileNames().size() == 1 && Intrinsics.areEqual((Object)this.parsedArgs.getFileNames().get(0), (Object)"-")) {
            boolean success = this.formatStdin();
            return success ? 0 : 1;
        }
        List<File> files = null;
        try {
            files = MainKt.expandArgsToFileNames(this.parsedArgs.getFileNames());
        }
        catch (IllegalStateException e) {
            this.err.println(e.getMessage());
            return 1;
        }
        if (files.isEmpty()) {
            this.err.println("Error: no .kt files found");
            return 1;
        }
        AtomicBoolean success = new AtomicBoolean(true);
        files.parallelStream().forEach(arg_0 -> Main.run$lambda-0(success, this, arg_0));
        return success.get() ? 0 : 1;
    }

    @VisibleForTesting
    public final boolean formatStdin() {
        String code = TextStreamsKt.readText((Reader)new BufferedReader(new InputStreamReader(this.input)));
        try {
            this.out.print(FormatterKt.format(this.parsedArgs.getFormattingOptions(), code));
            return true;
        }
        catch (ParseError e) {
            this.handleParseError("<stdin>", e);
            return false;
        }
    }

    private final boolean formatFile(File file) {
        try {
            String code = FilesKt.readText$default((File)file, null, (int)1, null);
            FilesKt.writeText$default((File)file, (String)FormatterKt.format(this.parsedArgs.getFormattingOptions(), code), null, (int)2, null);
            this.err.println(Intrinsics.stringPlus((String)"Done formatting ", (Object)file));
            return true;
        }
        catch (IOException e) {
            this.err.println("Error formatting " + file + ": " + e.getMessage() + "; skipping.");
        }
        catch (ParseError e) {
            String string = file.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.toString()");
            this.handleParseError(string, e);
        }
        catch (FormattingError e) {
            for (FormatterDiagnostic diagnostic : e.diagnostics()) {
                System.err.println("" + file + ':' + diagnostic);
            }
            e.printStackTrace(this.err);
        }
        return false;
    }

    private final void handleParseError(String fileName, ParseError e) {
        this.err.println(fileName + ':' + e.getMessage());
    }

    private static final void run$lambda-0(AtomicBoolean $success, Main this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)$success, (String)"$success");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $success.compareAndSet(true, this$0.formatFile(it));
    }
}

