/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.NestingCounter;
import com.facebook.ktfmt.kdoc.Token;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u000289B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0002J\u0006\u0010\u001b\u001a\u00020\u0018J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\u0006\u0010\u001d\u001a\u00020\u0018J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\u0006\u0010\u001f\u001a\u00020\u0018J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020\u0018J\b\u0010#\u001a\u00020\u0018H\u0002J\u000e\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u000e\u0010(\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u0006\u0010)\u001a\u00020\u0018J\u000e\u0010*\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u0006\u0010+\u001a\u00020\u0018J\u000e\u0010,\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u000e\u0010-\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u000e\u0010.\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u0012\u0010/\u001a\u00020\u00182\b\b\u0002\u00100\u001a\u000201H\u0002J\u000e\u00102\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u000e\u00103\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u000e\u00104\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u000e\u00105\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u000e\u00106\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&J\u0010\u00107\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0002R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocWriter;", "", "blockIndent", "", "maxLineLength", "(II)V", "START_OF_LINE_TOKENS", "Lcom/google/common/collect/ImmutableSet;", "Lcom/facebook/ktfmt/kdoc/Token$Type;", "kotlin.jvm.PlatformType", "atStartOfLine", "", "continuingListCount", "Lcom/facebook/ktfmt/kdoc/NestingCounter;", "continuingListItemCount", "continuingListItemOfInnermostList", "inCodeBlock", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "remainingOnLine", "requestedWhitespace", "Lcom/facebook/ktfmt/kdoc/KDocWriter$RequestedWhitespace;", "appendSpaces", "", "count", "innerIndent", "requestBlankLine", "requestCloseCodeBlockMarker", "requestNewline", "requestOpenCodeBlockMarker", "requestWhitespace", "toString", "", "writeBeginJavadoc", "writeBlankLine", "writeCodeClose", "token", "Lcom/facebook/ktfmt/kdoc/Token;", "writeCodeLine", "writeCodeOpen", "writeEndJavadoc", "writeExplicitCodeBlockMarker", "writeLineBreakNoAutoIndent", "writeListItemOpen", "writeLiteral", "writeMarkdownLink", "writeNewline", "autoIndent", "Lcom/facebook/ktfmt/kdoc/KDocWriter$AutoIndent;", "writePreClose", "writePreOpen", "writeTableClose", "writeTableOpen", "writeTag", "writeToken", "AutoIndent", "RequestedWhitespace", "ktfmt"})
public final class KDocWriter {
    private final int blockIndent;
    private final int maxLineLength;
    private final ImmutableSet<Token.Type> START_OF_LINE_TOKENS;
    @NotNull
    private final StringBuilder output;
    private boolean continuingListItemOfInnermostList;
    @NotNull
    private final NestingCounter continuingListItemCount;
    @NotNull
    private final NestingCounter continuingListCount;
    private int remainingOnLine;
    private boolean atStartOfLine;
    @NotNull
    private RequestedWhitespace requestedWhitespace;
    private boolean inCodeBlock;

    public KDocWriter(int blockIndent, int maxLineLength) {
        this.blockIndent = blockIndent;
        this.maxLineLength = maxLineLength;
        Token.Type[] typeArray = new Token.Type[]{Token.Type.PARAGRAPH_OPEN_TAG, Token.Type.HEADER_OPEN_TAG};
        this.START_OF_LINE_TOKENS = Sets.immutableEnumSet((Enum)Token.Type.LIST_ITEM_OPEN_TAG, (Enum[])typeArray);
        this.output = new StringBuilder();
        this.continuingListItemCount = new NestingCounter();
        this.continuingListCount = new NestingCounter();
        this.requestedWhitespace = RequestedWhitespace.NONE;
    }

    public final void requestWhitespace() {
        this.requestWhitespace(RequestedWhitespace.WHITESPACE);
    }

    public final void writeBeginJavadoc() {
        this.output.append("/**");
    }

    public final void writeEndJavadoc() {
        this.requestCloseCodeBlockMarker();
        this.output.append("\n");
        this.appendSpaces(this.blockIndent + 1);
        this.output.append("*/");
    }

    public final void writeListItemOpen(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestCloseCodeBlockMarker();
        this.requestNewline();
        if (this.continuingListItemOfInnermostList) {
            this.continuingListItemOfInnermostList = false;
            this.continuingListItemCount.decrementIfPositive();
        }
        this.writeToken(token);
        this.continuingListItemOfInnermostList = true;
        this.continuingListItemCount.increment();
    }

    public final void writePreOpen(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestBlankLine();
        this.writeToken(token);
    }

    public final void writePreClose(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
        this.requestBlankLine();
    }

    public final void writeCodeOpen(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
    }

    public final void writeCodeClose(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
    }

    public final void writeTableOpen(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestBlankLine();
        this.writeToken(token);
    }

    public final void writeTableClose(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
        this.requestBlankLine();
    }

    public final void writeLineBreakNoAutoIndent() {
        this.writeNewline(AutoIndent.NO_AUTO_INDENT);
    }

    public final void writeTag(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestNewline();
        this.writeToken(token);
    }

    public final void writeCodeLine(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestOpenCodeBlockMarker();
        this.requestNewline();
        CharSequence charSequence = token.getValue();
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.writeToken(token);
        }
    }

    private final void requestCloseCodeBlockMarker() {
        if (this.inCodeBlock) {
            this.requestedWhitespace = RequestedWhitespace.NEWLINE;
            this.writeExplicitCodeBlockMarker(new Token(Token.Type.CODE_BLOCK_MARKER, "```"));
            this.inCodeBlock = false;
        }
    }

    private final void requestOpenCodeBlockMarker() {
        if (!this.inCodeBlock) {
            this.requestedWhitespace = RequestedWhitespace.NEWLINE;
            this.writeExplicitCodeBlockMarker(new Token(Token.Type.CODE_BLOCK_MARKER, "```"));
            this.inCodeBlock = true;
        }
    }

    public final void writeExplicitCodeBlockMarker(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestNewline();
        this.writeToken(token);
        this.requestNewline();
        this.inCodeBlock = !this.inCodeBlock;
    }

    public final void writeLiteral(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestCloseCodeBlockMarker();
        this.writeToken(token);
    }

    public final void writeMarkdownLink(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
    }

    @NotNull
    public String toString() {
        String string = this.output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.toString()");
        return string;
    }

    public final void requestBlankLine() {
        this.requestWhitespace(RequestedWhitespace.BLANK_LINE);
    }

    public final void requestNewline() {
        this.requestWhitespace(RequestedWhitespace.NEWLINE);
    }

    private final void requestWhitespace(RequestedWhitespace requestedWhitespace) {
        Object object = Ordering.natural().max((Object)requestedWhitespace, (Object)this.requestedWhitespace);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"natural<Comparable<*>>().max(requestedWhitespace, this.requestedWhitespace)");
        this.requestedWhitespace = (RequestedWhitespace)((Object)object);
    }

    /*
     * Unable to fully structure code
     */
    private final void writeToken(Token token) {
        if (this.requestedWhitespace == RequestedWhitespace.BLANK_LINE && this.continuingListItemCount.isPositive()) {
            this.continuingListCount.reset();
            this.continuingListItemCount.reset();
        }
        if (this.requestedWhitespace == RequestedWhitespace.BLANK_LINE) {
            this.writeBlankLine();
            this.requestedWhitespace = RequestedWhitespace.NONE;
        } else if (this.requestedWhitespace == RequestedWhitespace.NEWLINE) {
            KDocWriter.writeNewline$default(this, null, 1, null);
            this.requestedWhitespace = RequestedWhitespace.NONE;
        }
        if (this.requestedWhitespace == RequestedWhitespace.WHITESPACE) ** GOTO lbl-1000
        if (this.requestedWhitespace == RequestedWhitespace.CONDITIONAL_WHITESPACE) {
            var3_2 = StringsKt.first((CharSequence)token.getValue());
            var4_5 = 0;
            ** if (!Character.isLetterOrDigit((char)var3_2)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl20
        }
lbl-1000:
        // 2 sources

        {
            v0 = needWhitespace = false;
        }
lbl20:
        // 2 sources

        if (!this.atStartOfLine && token.length() + (needWhitespace != false ? 1 : 0) > this.remainingOnLine) {
            KDocWriter.writeNewline$default(this, null, 1, null);
        }
        if (!this.atStartOfLine && needWhitespace) {
            this.output.append(" ");
            var3_3 = this;
            var4_5 = var3_3.remainingOnLine;
            var3_3.remainingOnLine = var4_5 + -1;
        }
        this.output.append(token.getValue());
        if (!this.START_OF_LINE_TOKENS.contains((Object)token.getType())) {
            this.atStartOfLine = false;
        }
        var3_4 = this;
        var3_4.remainingOnLine -= token.length();
        this.requestedWhitespace = RequestedWhitespace.NONE;
    }

    private final void writeBlankLine() {
        this.output.append("\n");
        this.appendSpaces(this.blockIndent + 1);
        this.output.append("*");
        KDocWriter.writeNewline$default(this, null, 1, null);
    }

    private final void writeNewline(AutoIndent autoIndent) {
        this.output.append("\n");
        this.appendSpaces(this.blockIndent + 1);
        this.output.append("*");
        this.appendSpaces(1);
        this.remainingOnLine = this.maxLineLength - this.blockIndent - 3;
        if (autoIndent == AutoIndent.AUTO_INDENT) {
            this.appendSpaces(this.innerIndent());
            KDocWriter kDocWriter = this;
            kDocWriter.remainingOnLine -= this.innerIndent();
        }
        this.atStartOfLine = true;
    }

    static /* synthetic */ void writeNewline$default(KDocWriter kDocWriter, AutoIndent autoIndent, int n, Object object) {
        if ((n & 1) != 0) {
            autoIndent = AutoIndent.AUTO_INDENT;
        }
        kDocWriter.writeNewline(autoIndent);
    }

    private final int innerIndent() {
        return 0;
    }

    private final void appendSpaces(int count) {
        this.output.append(Strings.repeat((String)" ", (int)count));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocWriter$RequestedWhitespace;", "", "(Ljava/lang/String;I)V", "NONE", "CONDITIONAL_WHITESPACE", "WHITESPACE", "NEWLINE", "BLANK_LINE", "ktfmt"})
    public static final class RequestedWhitespace
    extends Enum<RequestedWhitespace> {
        public static final /* enum */ RequestedWhitespace NONE = new RequestedWhitespace();
        public static final /* enum */ RequestedWhitespace CONDITIONAL_WHITESPACE = new RequestedWhitespace();
        public static final /* enum */ RequestedWhitespace WHITESPACE = new RequestedWhitespace();
        public static final /* enum */ RequestedWhitespace NEWLINE = new RequestedWhitespace();
        public static final /* enum */ RequestedWhitespace BLANK_LINE = new RequestedWhitespace();
        private static final /* synthetic */ RequestedWhitespace[] $VALUES;

        public static RequestedWhitespace[] values() {
            RequestedWhitespace[] requestedWhitespaceArray = $VALUES;
            return Arrays.copyOf(requestedWhitespaceArray, requestedWhitespaceArray.length);
        }

        public static RequestedWhitespace valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(RequestedWhitespace.class, value);
        }

        static {
            $VALUES = requestedWhitespaceArray = new RequestedWhitespace[]{RequestedWhitespace.NONE, RequestedWhitespace.CONDITIONAL_WHITESPACE, RequestedWhitespace.WHITESPACE, RequestedWhitespace.NEWLINE, RequestedWhitespace.BLANK_LINE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocWriter$AutoIndent;", "", "(Ljava/lang/String;I)V", "AUTO_INDENT", "NO_AUTO_INDENT", "ktfmt"})
    public static final class AutoIndent
    extends Enum<AutoIndent> {
        public static final /* enum */ AutoIndent AUTO_INDENT = new AutoIndent();
        public static final /* enum */ AutoIndent NO_AUTO_INDENT = new AutoIndent();
        private static final /* synthetic */ AutoIndent[] $VALUES;

        public static AutoIndent[] values() {
            AutoIndent[] autoIndentArray = $VALUES;
            return Arrays.copyOf(autoIndentArray, autoIndentArray.length);
        }

        public static AutoIndent valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(AutoIndent.class, value);
        }

        static {
            $VALUES = autoIndentArray = new AutoIndent[]{AutoIndent.AUTO_INDENT, AutoIndent.NO_AUTO_INDENT};
        }
    }
}

