/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.wsdl.Constants;
import com.sforce.ws.wsdl.Enumeration;
import com.sforce.ws.wsdl.ParserUtil;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class Restriction
implements Constants {
    private ArrayList<Enumeration> enumerations = new ArrayList();
    private QName base;
    private Schema schema;

    public Restriction(Schema schema) {
        this.schema = schema;
    }

    public Iterator<Enumeration> getElements() {
        return this.enumerations.iterator();
    }

    public int getNumEnumerations() {
        return this.enumerations.size();
    }

    public String toString() {
        return "Restriction{enumerations=" + this.enumerations + '}';
    }

    public QName getBase() {
        return this.base;
    }

    void read(WsdlParser parser) throws WsdlParseException {
        String baseLocal = parser.getAttributeValue(null, "base");
        this.base = baseLocal != null ? ParserUtil.toQName(baseLocal, parser) : null;
        int eventType = parser.getEventType();
        while (true) {
            String namespace;
            String name;
            if (eventType == 2) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("enumeration".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    Enumeration enumeration = new Enumeration(this.schema);
                    enumeration.read(parser);
                    this.enumerations.add(enumeration);
                }
            } else if (eventType == 3) {
                name = parser.getName();
                namespace = parser.getNamespace();
                if ("restriction".equals(name) && "http://www.w3.org/2001/XMLSchema".equals(namespace)) {
                    return;
                }
            } else if (eventType == 1) {
                throw new WsdlParseException("Failed to find end tag for 'restriction'");
            }
            eventType = parser.next();
        }
    }
}

