/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.wsdl;

import com.sforce.ws.parser.XmlInputStream;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.WsdlParseException;
import com.sforce.ws.wsdl.WsdlParser;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class WsdlFactory {
    public static Definitions create(String url) throws WsdlParseException {
        InputStream in;
        try {
            try {
                in = new URL(url).openStream();
            }
            catch (MalformedURLException e) {
                in = new FileInputStream(url);
            }
        }
        catch (IOException e) {
            throw new WsdlParseException(e);
        }
        XmlInputStream parser = new XmlInputStream();
        WsdlParser wsdlParser = new WsdlParser(parser);
        Definitions definitions = new Definitions();
        wsdlParser.setInput(in, "UTF-8");
        definitions.read(wsdlParser);
        return definitions;
    }

    public static Definitions createFromString(String wsdl) throws WsdlParseException {
        XmlInputStream parser = new XmlInputStream();
        WsdlParser wsdlParser = new WsdlParser(parser);
        Definitions definitions = new Definitions();
        ByteArrayInputStream bio = new ByteArrayInputStream(wsdl.getBytes());
        wsdlParser.setInput(bio, "UTF-8");
        definitions.read(wsdlParser);
        return definitions;
    }
}

