/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.bind;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.TypeInfo;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.bind.XMLizable;
import com.sforce.ws.bind.XmlTypeInfoProvider;
import com.sforce.ws.parser.XmlInputStream;
import com.sforce.ws.parser.XmlOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class XmlObject
implements XMLizable {
    private QName name;
    private QName xmlType;
    private Object value;
    private String defaultNamespace;
    private ArrayList<XmlObject> children = new ArrayList();

    public XmlObject() {
        this(null, null);
    }

    public XmlObject(QName name) {
        this(name, null);
    }

    public XmlObject(QName name, Object value) {
        this.name = name;
        this.value = value;
    }

    public QName getName() {
        return this.name;
    }

    public void setName(QName name) {
        this.name = name;
    }

    public void setDefaultNamespace(String namespace) {
        this.defaultNamespace = namespace;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean hasChildren() {
        return this.children.size() != 0;
    }

    public XmlObject addField(String name, Object value) {
        return this.addOrSetField(name, value, false);
    }

    public XmlObject setField(String name, Object value) {
        return this.addOrSetField(name, value, true);
    }

    public Iterator<XmlObject> evaluate(String xpath) {
        String[] paths;
        if (xpath == null) {
            throw new NullPointerException("xpath can not be null");
        }
        ArrayList<XmlObject> parents = new ArrayList<XmlObject>();
        ArrayList<XmlObject> nodes = new ArrayList<XmlObject>();
        parents.add(this);
        for (String path : paths = xpath.split("/")) {
            nodes = new ArrayList();
            for (XmlObject parent : parents) {
                Iterator<XmlObject> it = parent.getChildren(path);
                while (it.hasNext()) {
                    nodes.add(it.next());
                }
            }
            if (nodes.size() == 0) break;
            parents = nodes;
        }
        return nodes.iterator();
    }

    private XmlObject addOrSetField(String n, Object value, boolean set) {
        XmlObject child = null;
        if (value instanceof XmlObject) {
            child = (XmlObject)value;
            child.name = this.getQNameFor(n);
            this.children.add(child);
        } else {
            if (set) {
                child = this.findField(n);
            }
            if (child == null) {
                child = new XmlObject(this.getQNameFor(n), value);
                this.children.add(child);
            } else {
                child.setValue(value);
            }
        }
        return child;
    }

    private QName getQNameFor(String n) {
        String namespace = this.defaultNamespace == null ? "urn:sobject.partner.soap.sforce.com" : this.defaultNamespace;
        return this.name == null ? new QName(namespace, n) : new QName(this.name.getNamespaceURI(), n);
    }

    public boolean removeField(String name) {
        XmlObject item = this.findField(name);
        return item != null && this.children.remove(item);
    }

    public Object getField(String name) {
        XmlObject item = this.findField(name);
        Object result = null;
        if (item != null) {
            result = item.hasChildren() ? item : item.getValue();
        }
        return result;
    }

    public XmlObject getChild(String name) {
        return this.findField(name);
    }

    private XmlObject findField(String name) {
        XmlObject item = null;
        for (XmlObject child : this.children) {
            if (!child.getName().getLocalPart().equals(name)) continue;
            item = child;
            break;
        }
        return item;
    }

    public Iterator<XmlObject> getChildren() {
        return this.children.iterator();
    }

    public Iterator<XmlObject> getChildren(String name) {
        ArrayList<XmlObject> result = new ArrayList<XmlObject>();
        for (XmlObject child : this.children) {
            if (!child.getName().getLocalPart().equals(name)) continue;
            result.add(child);
        }
        return result.iterator();
    }

    public String toString() {
        return "XmlObject{name=" + this.name + ", value=" + this.value + ", children=" + this.children + '}';
    }

    @Override
    public void write(QName element, XmlOutputStream out, TypeMapper typeMapper) throws IOException {
        typeMapper.writeFieldXsiType(true);
        if (this.hasChildren()) {
            out.writeStartTag(element.getNamespaceURI(), element.getLocalPart());
            for (XmlObject child : this.children) {
                child.write(child.getName(), out, typeMapper);
            }
            out.writeEndTag(element.getNamespaceURI(), element.getLocalPart());
        } else if (this.value != null) {
            TypeInfo info = null;
            if (this.value instanceof XmlTypeInfoProvider) {
                info = ((XmlTypeInfoProvider)this.value).getTypeInfo(this.name.getNamespaceURI(), this.name.getLocalPart(), typeMapper);
            }
            if (info == null) {
                int max;
                QName xmlType = typeMapper.getXmlType(this.value.getClass().getName());
                for (Class<?> classForType = this.value.getClass(); classForType != Object.class && xmlType == null; classForType = classForType.getSuperclass()) {
                    xmlType = typeMapper.getXmlType(classForType.getName());
                }
                if (xmlType == null) {
                    throw new IOException("Unable to find xml type for :" + this.value.getClass().getName());
                }
                int n = max = this.value.getClass().isArray() ? -1 : 1;
                if (this.value.getClass().getName().equals("[B")) {
                    max = 1;
                }
                info = new TypeInfo(this.name.getNamespaceURI(), this.name.getLocalPart(), xmlType.getNamespaceURI(), xmlType.getLocalPart(), 0, max, true);
            }
            typeMapper.writeObject(out, info, this.value, true);
        }
        typeMapper.writeFieldXsiType(false);
    }

    @Override
    public void load(XmlInputStream in, TypeMapper typeMapper) throws IOException, ConnectionException {
        this.loadStartTag(in, typeMapper);
        this.loadAfterStartTag(in, typeMapper);
    }

    protected void loadStartTag(XmlInputStream in, TypeMapper typeMapper) {
        in.consumePeeked();
        this.name = new QName(in.getNamespace(), in.getName());
        this.xmlType = typeMapper.getXsiType(in);
    }

    protected void loadAfterStartTag(XmlInputStream in, TypeMapper typeMapper) throws IOException, ConnectionException {
        boolean textFound;
        StringBuilder text;
        block5: {
            int type;
            block4: {
                text = new StringBuilder();
                textFound = false;
                while (true) {
                    if ((type = in.next()) == 2) {
                        XmlObject child = new XmlObject();
                        child.load(in, typeMapper);
                        this.children.add(child);
                        continue;
                    }
                    if (type == 4) {
                        text.append(in.getText());
                        textFound = true;
                        continue;
                    }
                    if (type != 3) break block4;
                    String ns = in.getNamespace();
                    String n = in.getName();
                    if (this.name.getNamespaceURI().equals(ns) && this.name.getLocalPart().equals(n)) break;
                }
                break block5;
            }
            throw new ConnectionException("unknown tag:" + type + " at " + in);
        }
        if (textFound) {
            this.value = typeMapper.deserialize(text.toString(), this.xmlType);
        }
    }

    protected void cloneFrom(XmlObject source) {
        this.name = source.name;
        this.xmlType = source.xmlType;
        this.value = source.value;
        this.defaultNamespace = source.defaultNamespace;
        this.children = source.children;
    }
}

