/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

class ToolsJarClassLoader
extends ClassLoader {
    private JarFile toolsJar;

    ToolsJarClassLoader(ClassLoader parent) throws IOException {
        super(parent);
        String javaHome = System.getProperty("java.home");
        if (javaHome.endsWith("jre")) {
            javaHome = javaHome.substring(0, javaHome.length() - 3);
        }
        if (!javaHome.endsWith("/")) {
            javaHome = javaHome + "/";
        }
        String tj = javaHome + "lib/tools.jar";
        File tjf = new File(tj);
        this.toolsJar = new JarFile(tjf);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] b;
        try {
            b = this.getBytes(name);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(null, b, 0, b.length);
    }

    private byte[] getBytes(String name) throws IOException, ClassNotFoundException {
        int ch;
        name = name.replace(".", "/");
        JarEntry entry = this.toolsJar.getJarEntry(name = name + ".class");
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        InputStream io = this.toolsJar.getInputStream(entry);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        while ((ch = io.read()) != -1) {
            bout.write((char)ch);
        }
        io.close();
        return bout.toByteArray();
    }
}

