/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import com.sun.jersey.api.representation.Form;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.BrowsableEndpoint;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.web.model.EndpointLink;
import org.apache.camel.web.resources.CamelChildResourceSupport;
import org.apache.camel.web.resources.CamelContextResource;
import org.apache.camel.web.resources.ExchangeResource;

public class EndpointResource
extends CamelChildResourceSupport {
    private final String key;
    private final Endpoint endpoint;

    public EndpointResource(CamelContextResource contextResource, String key, Endpoint endpoint) {
        super(contextResource);
        this.key = key;
        this.endpoint = endpoint;
    }

    public String getHref() {
        return new EndpointLink(this.key, this.endpoint).getHref();
    }

    public String getKey() {
        return this.key;
    }

    public String getUri() {
        return this.endpoint.getEndpointUri();
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public BrowsableEndpoint getBrowsableEndpoint() {
        if (this.endpoint instanceof BrowsableEndpoint) {
            return (BrowsableEndpoint)this.endpoint;
        }
        return null;
    }

    @Path(value="messages/{id}")
    public ExchangeResource getExchange(@PathParam(value="id") String exchangeId) {
        BrowsableEndpoint browsableEndpoint;
        Exchange exchange;
        if (this.endpoint instanceof BrowsableEndpoint && (exchange = ExchangeHelper.getExchangeById((Iterable)(browsableEndpoint = (BrowsableEndpoint)this.endpoint).getExchanges(), (String)exchangeId)) != null) {
            return new ExchangeResource(this, exchange);
        }
        return null;
    }

    @POST
    @Consumes(value={"text/plain", "text/html", "text/xml", "application/xml"})
    public Response postMessage(@Context HttpHeaders headers, String body) throws URISyntaxException {
        Map messageHeaders = this.multivalueMapToMap(headers.getRequestHeaders());
        this.sendMessage(messageHeaders, body);
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postMessageForm(@Context HttpHeaders headers, Form formData) throws URISyntaxException {
        String body = this.getBodyData(formData);
        Map messageHeaders = this.multivalueMapToMap(headers.getRequestHeaders());
        messageHeaders.putAll(this.getHeadersData(formData));
        this.sendMessage(messageHeaders, body);
        return Response.seeOther((URI)new URI(this.getHref())).build();
    }

    private Map<String, Object> getHeadersData(Form formData) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        Map formMap = this.multivalueMapToMap((MultivaluedMap)formData);
        for (Map.Entry entry : formMap.entrySet()) {
            if (!((String)entry.getKey()).startsWith("header_")) continue;
            headers.put((String)entry.getValue(), this.getHeaderValueForKey((String)entry.getKey(), formMap));
        }
        return headers;
    }

    private Object getHeaderValueForKey(String key, Map<String, Object> headers) {
        return headers.get("value_" + key);
    }

    private String getBodyData(Form formData) {
        return (String)formData.getFirst("body", String.class);
    }

    private Map<String, Object> multivalueMapToMap(MultivaluedMap<String, String> multivaluedMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (multivaluedMap != null) {
            for (Map.Entry entry : multivaluedMap.entrySet()) {
                List values = (List)entry.getValue();
                int size = values.size();
                if (size == 1) {
                    resultMap.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
                    continue;
                }
                if (size <= 0) continue;
                resultMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        return resultMap;
    }

    protected void sendMessage(Map<String, Object> headers, String body) {
        this.getTemplate().send(this.endpoint, (Processor)new /* Unavailable Anonymous Inner Class!! */);
    }
}

