/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import com.sun.jersey.api.view.Viewable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.RouteDotGenerator;
import org.apache.camel.web.resources.CamelChildResourceSupport;
import org.apache.camel.web.resources.RouteStatusResource;
import org.apache.camel.web.resources.RoutesResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteResource
extends CamelChildResourceSupport {
    public static final String LANGUAGE_XML = "Xml";
    private static final transient Logger LOG = LoggerFactory.getLogger(RouteResource.class);
    private RouteDefinition route;
    private String error = "";
    private String id;
    private String language = "Xml";

    public RouteResource(RoutesResource routesResource, RouteDefinition route) {
        super(routesResource.getContextResource());
        this.route = route;
        this.id = route.idOrCreate(this.getCamelContext().getNodeIdFactory());
    }

    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public RouteDefinition getRoute() {
        return this.route;
    }

    @GET
    @Path(value="remove")
    @Produces(value={"text/html"})
    public Response removeRoute() {
        URI routesURI = null;
        try {
            routesURI = new URI("/routes");
            ((ModelCamelContext)this.getCamelContext()).removeRouteDefinition(this.route);
            return Response.seeOther((URI)routesURI).build();
        }
        catch (Exception e) {
            LOG.error("failed to remove route " + this.id + ", error " + e.getMessage());
            return Response.seeOther((URI)routesURI).build();
        }
    }

    public String getRouteXml() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.web.model");
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)this.route, (Writer)buffer);
        return buffer.toString();
    }

    public String getRouteDefinition() {
        if (this.language.equalsIgnoreCase(LANGUAGE_XML)) {
            try {
                return this.getRouteXml();
            }
            catch (JAXBException e) {
                return "Error on marshal the route definition!";
            }
        }
        return "Unsupported language!";
    }

    @GET
    @Produces(value={"text/vnd.graphviz"})
    public String getDot() throws IOException {
        RouteDotGenerator generator = new RouteDotGenerator("/tmp/camel");
        return generator.getRoutesText(this.getCamelContext());
    }

    @POST
    @Consumes
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public void postRoute(RouteDefinition routeDefinition) throws Exception {
        routeDefinition.setId(this.id);
        ((ModelCamelContext)this.getCamelContext()).addRouteDefinitions(Collections.singletonList(routeDefinition));
    }

    public void postRoutes(RouteBuilder builder) throws Exception {
        DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.getCamelContext();
        defaultCamelContext.stopRoute(this.id);
        defaultCamelContext.removeRoute(this.id);
        defaultCamelContext.addRoutes((RoutesBuilder)builder);
        List routeDefinitions = defaultCamelContext.getRouteDefinitions();
        RouteDefinition route = (RouteDefinition)routeDefinitions.get(routeDefinitions.size() - 1);
        route.setId(this.id);
        defaultCamelContext.startRoute(route);
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postRouteForm(@Context UriInfo uriInfo, @FormParam(value="language") String language, @FormParam(value="route") String body, @FormParam(value="edited") String edited) throws URISyntaxException {
        if (edited.equals("false")) {
            return Response.seeOther((URI)new URI("/routes")).build();
        }
        LOG.debug("New Route is: {}", (Object)body);
        LOG.info(body);
        if (body == null) {
            this.error = "No Route submitted!";
        } else if (language.equals(LANGUAGE_XML)) {
            return this.parseXml(body);
        }
        this.error = "Not supproted language!";
        return Response.ok((Object)new Viewable("edit", (Object)this)).build();
    }

    private Response parseXml(String xml) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.web.model");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object value = unmarshaller.unmarshal((Reader)new StringReader(xml));
            if (value instanceof RouteDefinition) {
                RouteDefinition routeDefinition = (RouteDefinition)value;
                this.postRoute(routeDefinition);
                return Response.seeOther((URI)new URI("/routes")).build();
            }
            this.error = "Posted XML is not a route but is of type " + ObjectHelper.className((Object)value);
        }
        catch (JAXBException e) {
            this.error = "Failed to parse XML: " + e.getMessage();
        }
        catch (Exception e) {
            this.error = "Failed to install route: " + e.getMessage();
        }
        return Response.ok((Object)new Viewable("edit", (Object)this)).build();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = LANGUAGE_XML;
    }

    @Path(value="status")
    public RouteStatusResource getRouteStatus() {
        return new RouteStatusResource(this);
    }

    public String getError() {
        return this.error;
    }

    public String getId() {
        return this.id;
    }
}

