/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import com.sun.jersey.api.view.Viewable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.view.RouteDotGenerator;
import org.apache.camel.web.model.Route;
import org.apache.camel.web.resources.CamelChildResourceSupport;
import org.apache.camel.web.resources.CamelContextResource;
import org.apache.camel.web.resources.RouteResource;
import org.apache.camel.web.resources.RouteStatusResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutesResource
extends CamelChildResourceSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(RoutesResource.class);
    private String error = "";

    public RoutesResource(CamelContextResource contextResource) {
        super(contextResource);
    }

    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public RoutesDefinition getRouteDefinitions() {
        RoutesDefinition answer = new RoutesDefinition();
        CamelContext camelContext = this.getCamelContext();
        if (camelContext != null) {
            List list = camelContext.getRouteDefinitions();
            answer.setRoutes(list);
        }
        return answer;
    }

    @GET
    @Produces(value={"text/vnd.graphviz"})
    public String getDot() throws IOException {
        RouteDotGenerator generator = new RouteDotGenerator("/tmp/camel");
        return generator.getRoutesText(this.getCamelContext());
    }

    @Path(value="{id}")
    public RouteResource getRoute(@PathParam(value="id") String id) {
        List list = this.getRouteDefinitions().getRoutes();
        for (RouteDefinition routeType : list) {
            if (!routeType.getId().equals(id)) continue;
            return new RouteResource(this, routeType);
        }
        return null;
    }

    @Path(value="{id}/lang/{language}")
    public RouteResource getRoute(@PathParam(value="id") String id, @PathParam(value="language") String language) {
        RouteResource routeResource = this.getRoute(id);
        if (routeResource != null) {
            routeResource.setLanguage(language);
        }
        return routeResource;
    }

    @Path(value="{id}/status")
    public RouteStatusResource getRouteStatus(@PathParam(value="id") String id) {
        RouteResource routeResource = this.getRoute(id);
        return routeResource.getRouteStatus();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postRouteForm(@Context UriInfo uriInfo, @FormParam(value="language") String language, @FormParam(value="route") String body) throws URISyntaxException {
        LOG.debug("New Route is: {}", (Object)body);
        LOG.info(body);
        if (body == null) {
            this.error = "No Route submitted!";
        } else if (language.equals("Xml")) {
            return this.parseXml(body);
        }
        this.error = "Not supported language!";
        return Response.ok((Object)new Viewable("edit", (Object)this)).build();
    }

    public List<Route> getRoutes() {
        ArrayList<Route> answer = new ArrayList<Route>();
        for (RouteDefinition def : this.getRouteDefinitions().getRoutes()) {
            Route route = new Route(this.getCamelContext(), def);
            answer.add(route);
        }
        return answer;
    }

    public String getError() {
        return this.error;
    }

    private Response parseXml(String xml) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.apache.camel:org.apache.camel.model:org.apache.camel.model.config:org.apache.camel.model.dataformat:org.apache.camel.model.language:org.apache.camel.model.loadbalancer:org.apache.camel.web.model");
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object value = unmarshaller.unmarshal((Reader)new StringReader(xml));
            if (value instanceof RouteDefinition) {
                RouteDefinition routeDefinition = (RouteDefinition)value;
                ((ModelCamelContext)this.getCamelContext()).addRouteDefinitions(Collections.singletonList(routeDefinition));
                return Response.seeOther((URI)new URI("/routes")).build();
            }
            this.error = "Posted XML is not a route but is of type " + ObjectHelper.className((Object)value);
        }
        catch (JAXBException e) {
            this.error = "Failed to parse XML: " + e.getMessage();
        }
        catch (Exception e) {
            this.error = "Failed to install route: " + e.getMessage();
        }
        return Response.ok((Object)new Viewable("create", (Object)this)).build();
    }
}

