/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.rider.sample.camelamqweb;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;

public class SampleProducerAndConsumer {
    private final ConnectionFactory connectionFactory;
    private String queueName = "sample.jmsclient";
    private Connection connection;
    private Session producerSession;
    private Session consumerSession;
    private Destination destination;
    private boolean dynamicDestination = false;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private MessageListener messageListener = new /* Unavailable Anonymous Inner Class!! */;

    public SampleProducerAndConsumer(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @PostConstruct
    public void start() throws Exception {
        System.out.println("########## starting " + this);
        this.connection = this.connectionFactory.createConnection();
        this.producerSession = this.connection.createSession(false, 1);
        if (this.destination == null) {
            this.destination = this.producerSession.createQueue(this.queueName);
        }
        this.producer = this.dynamicDestination ? this.producerSession.createProducer(null) : this.producerSession.createProducer(this.destination);
        this.consumerSession = this.connection.createSession(false, 1);
        this.consumer = this.consumerSession.createConsumer(this.destination);
        this.consumer.setMessageListener(this.messageListener);
        this.connection.start();
        TextMessage message = this.producerSession.createTextMessage("<hello>world!</hello>");
        if (this.dynamicDestination) {
            this.producer.send(this.destination, (Message)message);
        } else {
            this.producer.send((Message)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PreDestroy
    public void stop() throws Exception {
        try {
            this.consumer.close();
            this.producer.close();
            this.producerSession.close();
            this.consumerSession.close();
        }
        finally {
            this.connection.close();
        }
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public MessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(MessageListener messageListener) {
        this.messageListener = messageListener;
    }

    public boolean isDynamicDestination() {
        return this.dynamicDestination;
    }

    public void setDynamicDestination(boolean dynamicDestination) {
        this.dynamicDestination = dynamicDestination;
    }
}

