/*
 * Copyright 2010 Red Hat, Inc.
 *
 *  Red Hat licenses this file to you under the Apache License, version
 *  2.0 (the "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *  implied.  See the License for the specific language governing
 *  permissions and limitations under the License.
 */
package com.fusesource.fmc.restjmx.model;

import javax.management.MBeanAttributeInfo;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Represents a MBean resource
 *
 * @version $Revision: 1.0 $
 */
@XmlRootElement(name = "attribute")
@XmlAccessorType(XmlAccessType.FIELD)
public class Attribute {
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String description;
    @XmlAttribute
    private String type;
    @XmlAttribute
    private String value;
    @XmlAttribute
    private String uriPath;
    
    public Attribute() {
    }

    public Attribute(String parentURIPath, MBeanAttributeInfo attributeInfo, Object value) {
        this.name = attributeInfo.getName();
        this.description = attributeInfo.getDescription();
        this.type = attributeInfo.getType();
        this.value = value == null ? null : value.toString();
        this.uriPath = parentURIPath + '/' + getName();
    }

    @Override
    public String toString() {
        return "Attribute{name='" + getName() + "' uriPath='" + getUriPath() + "'}";
    }

    public final String getName() {
        return name;
    }

    public String getDescription() {
        return description;
    }

    public String getType() {
        return type;
    }

    public String getValue() {
        return value;
    }

    public String getUriPath() {
        return uriPath;
    }
}
